
#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <mpi.h>

#include <sched.h>


void
helloworld()
{
   int          node;
   int          size;
   int          i;
   cpu_set_t    mask;
   char         verbose[1024];
   unsigned     ncpus;

   ncpus = sysconf(_SC_NPROCESSORS_CONF);

   MPI_Comm_rank(MPI_COMM_WORLD, &node);
   MPI_Comm_size(MPI_COMM_WORLD, &size);

   if(node==0) {
        printf("processor per node (check on rank 0): %d\n",ncpus);
        fflush(stdout);
   }

   (void) MPI_Barrier(MPI_COMM_WORLD) ;

   char hostname[255];
   if (gethostname(hostname,255)!=0)
       (void) strcpy(hostname,"unknown");

   sprintf(verbose,"proc %3d/%3d says Hello,World! (from node %s)",
                node,
                size,
                hostname);
   sched_getaffinity(0,sizeof(mask),&mask);
   for(i=0;i<ncpus;i++) {
        if(CPU_ISSET(i,&mask)!=0) {
                sprintf(verbose,"%s %d",verbose,i);
        }
   }
   puts(verbose);

   fflush(stdout);

}

main(int argc, char **argv)
{

   MPI_Init(&argc,&argv);

   (void) helloworld();

   MPI_Finalize();
}
