#!/bin/bash
#SBATCH --nodes=2-2
#SBATCH --exclusive

/opt/mpi/bullxmpi/1.0.4/bin/mpirun -npernode 1 -n 2 hostname > nodelist_$SLURM_JOBID

I=0
for node in $(cat nodelist_$SLURM_JOBID)
do
	echo rank ${I}=$node slot=0:0-3 >> rankfile_$SLURM_JOBID
	echo rank $((I+2))=$node slot=1:0-3 >> rankfile_$SLURM_JOBID
	I=$((I+1))
done
	
/opt/mpi/bullxmpi/1.0.4/bin/mpirun --prefix /opt/mpi/bullxmpi/1.0.4/bin/ -x OMP_NUM_THREADS=4 -x OMP_PROC_BIND=true --rankfile ./rankfile_$SLURM_JOBID -n 4 ./hw-omp 
