# Created by Jean M. Favre, Swiss National Supercomputing Center
# Thu Nov 30 17:16:42 CET 2017
# state file generated using paraview version 5.4.1

# ----------------------------------------------------------------
# setup views used in the visualization
# ----------------------------------------------------------------

#### import the simple module from the paraview
from paraview.simple import *
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

# Create a new 'Render View'
renderView1 = GetRenderView()

Script1 = """
import numpy as np
from vtk.util import numpy_support
executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)

ts = outInfo.Get(vtk.vtkStreamingDemandDrivenPipeline.UPDATE_TIME_STEP())
#print("Got update_time_step = ", ts)

nnodes = 10

ids = np.array(([0,nnodes-1]), dtype='int64')
varray = numpy_support.numpy_to_vtkIdTypeArray(ids)
varray.SetName("GlobalNodeIds")
output.GetPointData().SetGlobalIds(varray)

output.Points = make_vector(5*np.linspace(0,nnodes-1, 10)+np.sin(ts),ts*np.ones(nnodes),np.zeros(nnodes))

ptIds = vtk.vtkIdList()
ptIds.SetNumberOfIds(nnodes)
for a in range(nnodes):
  ptIds.SetId(a , a)
output.Allocate(1)
output.InsertNextCell(vtk.VTK_POLY_VERTEX , ptIds)

output.GetInformation().Set(output.DATA_TIME_STEP(), ts)
"""

Script2 = """
executive = self.GetExecutive ()
outInfo = executive.GetOutputInformation(0)

timesteps = [i*0.5 for i in range(100)]
timeRange = [timesteps[0], timesteps[-1]]
outInfo.Remove(vtk.vtkStreamingDemandDrivenPipeline.TIME_STEPS())
outInfo.Remove(vtk.vtkStreamingDemandDrivenPipeline.TIME_RANGE())
outInfo.Set(vtk.vtkStreamingDemandDrivenPipeline.TIME_RANGE(), timeRange, 2)
outInfo.Set(vtk.vtkStreamingDemandDrivenPipeline.TIME_STEPS(), timesteps, len(timesteps))
"""

# create a new 'Programmable Source'
programmableSource1 = ProgrammableSource()
programmableSource1.Script = Script1
programmableSource1.ScriptRequestInformation = Script2
programmableSource1.PythonPath = ''

# create a new 'Temporal Particles To Pathlines'
Particles2Pathes = TemporalParticlesToPathlines(Input=programmableSource1,
    Selection=None)
Particles2Pathes.MaskPoints = 1
Particles2Pathes.MaxTrackLength = 250
Particles2Pathes.MaxStepDistance = [10.0, 10.0, 10.0]
Particles2Pathes.IdChannelArray = 'GlobalNodeIds'


# get color transfer function/color map for 'GlobalNodeIds'
globalNodeIdsLUT = GetColorTransferFunction('GlobalNodeIds')
globalNodeIdsLUT.RGBPoints = [0.0, 0.231373, 0.298039, 0.752941, 3.5, 0.865003, 0.865003, 0.865003, 7.0, 0.705882, 0.0156863, 0.14902]
globalNodeIdsLUT.ScalarRangeInitialized = 1.0

# get opacity transfer function/opacity map for 'GlobalNodeIds'
globalNodeIdsPWF = GetOpacityTransferFunction('GlobalNodeIds')
globalNodeIdsPWF.Points = [0.0, 0.0, 0.5, 0.0, 7.0, 1.0, 0.5, 0.0]
globalNodeIdsPWF.ScalarRangeInitialized = 1

# show data from programmableSource1
programmableSource1Display = Show(programmableSource1, renderView1)
programmableSource1Display.Representation = 'Points'

# show data from Particles2Pathes
Particles2PathesDisplay = Show(Particles2Pathes, renderView1)
Particles2PathesDisplay.Representation = 'Surface'
Particles2PathesDisplay.ColorArrayName = ['POINTS', '']

Particles2PathesDisplay_1 = Show(OutputPort(Particles2Pathes, 1), renderView1)
Particles2PathesDisplay_1.Representation = 'Points'
Particles2PathesDisplay_1.ColorArrayName = ['POINTS', '']

SetActiveSource(programmableSource1)
Render

