# written by Jean M. Favre, Swiss National Supercomputing Centre
# Thu Nov 30 21:38:57 CET 2017
# tested with PV5.4

from paraview.simple import *

paraview.simple._DisableFirstRenderCameraReset()

# Create a new 'Render View'
renderView1 = GetRenderView()
renderView1.AxesGrid = 'GridAxes3DActor'
renderView1.CenterOfRotation = [5.0, 5.0, 5.0]
renderView1.StereoType = 0
renderView1.CameraPosition = [-22.01622340666536, 17.015021919074925, 20.66455117122583]
renderView1.CameraFocalPoint = [5.0000000000000195, 5.000000000000007, 4.999999999999989]
renderView1.CameraViewUp = [0.37109900651274075, -0.3077850189061124, 0.8761015406345436]
renderView1.CameraParallelScale = 8.660254037844387
renderView1.Background = [0.32, 0.34, 0.43]

RequestData = """
import numpy as np
from vtk.util import numpy_support

executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
exts = [executive.UPDATE_EXTENT().Get(outInfo, i) for i in range(6)]
output.SetExtent(exts)

ts = outInfo.Get(vtk.vtkStreamingDemandDrivenPipeline.UPDATE_TIME_STEP())
#print("Got update_time_step = ", ts)

cdata = np.sin(ts * np.array([1.0, 3.0, -2.0]))
pdata = np.cos(ts * np.array([1.0, 3.0, -2.0, 2.3, -3.4, 1.0, 3.0, -2.0]))

ids = np.arange(0,8,1,dtype='int64')
varray = numpy_support.numpy_to_vtkIdTypeArray(ids)
varray.SetName("GlobalNodeIds")
output.GetPointData().SetGlobalIds(varray)
  
output.CellData.append(cdata, "cell_scalar1")
#output.FieldData.append("TemporalStats", "name")
output.PointData.append(pdata, "node_scalar1")
output.GetInformation().Set(output.DATA_TIME_STEP(), ts)
"""

RequestInfo = """
executive = self.GetExecutive ()
outInfo = executive.GetOutputInformation(0)

dims = [4,2,1]
outInfo.Set(executive.WHOLE_EXTENT(), 0, dims[0]-1 , 0, dims[1]-1 , 0, dims[2]-1)
outInfo.Set(vtk.vtkDataObject.SPACING(), 1, 1, 1)
outInfo.Set(vtk.vtkDataObject.ORIGIN(), 0,0,0)

timesteps = [i*0.05 for i in range(100)]
timeRange = [timesteps[0], timesteps[-1]]
outInfo.Remove(vtk.vtkStreamingDemandDrivenPipeline.TIME_STEPS())
outInfo.Remove(vtk.vtkStreamingDemandDrivenPipeline.TIME_RANGE())
outInfo.Set(vtk.vtkStreamingDemandDrivenPipeline.TIME_RANGE(), timeRange, 2)
outInfo.Set(vtk.vtkStreamingDemandDrivenPipeline.TIME_STEPS(), timesteps, len(timesteps))
"""
# create a new 'Programmable Source'
programmableSource1 = ProgrammableSource()
programmableSource1.OutputDataSetType = 'vtkImageData'
programmableSource1.Script = RequestData
programmableSource1.ScriptRequestInformation = RequestInfo
programmableSource1.PythonPath = ''
programmableSource1.UpdatePipelineInformation()

animationScene1 = GetAnimationScene()
animationScene1.UpdateAnimationUsingDataTimeSteps()

# show data from programmableFilter1
programmableSource1Display = Show(programmableSource1, renderView1)
programmableSource1Display.Representation = 'Surface'
programmableSource1Display.ColorArrayName = ['POINTS', '']

Stats_ReqData = """
import numpy as np
executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
data = inputs[0].CellData[\'cell_scalar1\']

if self.CurrentTimeIndex == 0:
  print("------------------ INIT Phase-----------------------")
  print("        INIT: CurrentTimeIndex = ", self.CurrentTimeIndex, ", tlen = ", self.tlen)
  print("set data =", data)
  self.temp_data = data
  self.Accum = False
  request.Set(vtk.vtkStreamingDemandDrivenPipeline.CONTINUE_EXECUTING(), 1)
else:
  if not self.Accum:
    print("------------------ ACCUMULATE Phase-----------------------")
    self.Accum = True
  #print"  adding data ", data
#self.temp_data = np.maximum(data, self.temp_data)
  self.temp_data = data + self.temp_data

if self.CurrentTimeIndex < self.tlen:
  self.CurrentTimeIndex = self.CurrentTimeIndex + 1
else:
  # finish
  #print("------------------ FINAL Phase-----------------------")
  request.Remove(vtk.vtkStreamingDemandDrivenPipeline.CONTINUE_EXECUTING())
  #self.CurrentTimeIndex = 0

  output.CellData.append(self.temp_data/self.tlen, "new_data1")
  print("        FINISH: Finish")
  print("        avg_data =", self.temp_data/self.tlen)


"""

Stats_ReqInfo = """
print("------------------ BEGIN of REQUEST Information-----------------------")
executive = self.GetExecutive ()
outInfo = executive.GetOutputInformation(0)
self.CurrentTimeIndex = 0

self.tlen = outInfo.Length(executive.TIME_STEPS())
self.ts = [executive.TIME_STEPS().Get(outInfo, i) for i in range(self.tlen)]
#print("ReqInf: ts = ", self.ts)
#print("ReqInf: tlen = ", self.tlen)
# The output data of this filter has no time associated with it.
# It is the result of computations that happen over all time.
outInfo.Remove(executive.TIME_STEPS())
outInfo.Remove(executive.TIME_RANGE())
#print("Stats_ReqInfo: remove TIME_STEPS and TIME_RANGE")
print("------------------ END of REQUEST Information-----------------------")
"""

Stats_ReqExtents = """
executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)

if self.CurrentTimeIndex < self.tlen:
  #print("Set UPDATE_TIME_STEP = ", self.ts[self.CurrentTimeIndex])
  outInfo.Set(executive.UPDATE_TIME_STEP(), self.ts[self.CurrentTimeIndex])
"""

programmableFilter1 = ProgrammableFilter(Input=programmableSource1)
programmableFilter1.Script = Stats_ReqData
programmableFilter1.RequestInformationScript = Stats_ReqInfo
programmableFilter1.RequestUpdateExtentScript = Stats_ReqExtents
programmableFilter1.PythonPath = ''

programmableFilter1Display = Show(programmableFilter1, renderView1)
programmableFilter1Display.Representation = 'Outline'
programmableFilter1Display.ColorArrayName = ['POINTS', '']
programmableSource1.UpdatePipeline()
Render()
ResetCamera()

selection0 = IDSelectionSource()
selection0.FieldType="POINT"
selection0.IDs=[0,3]
selection0.UpdatePipelineInformation()

selection1=GlobalIDSelectionSource()
selection1.FieldType="POINT"
selection1.GlobalIDs=[3]
selection1.UpdatePipelineInformation()

selection2=SelectPoints()
selection2.QueryString="id == 3"
selection2.UpdatePipelineInformation()

plot = PlotSelectionOverTime(programmableSource1, Selection=selection2)
plot.OnlyReportSelectionStatistics = 0
plot.UpdatePipeline()

quartileChartView1 = CreateView('QuartileChartView')
quartileChartView1.ViewSize = [723, 980]
rep1 = Show(plot, quartileChartView1)
rep1.SeriesVisibility = ['node_scalar1 (Point Statistics)']

#SaveScreenshot('/home/jfavre/Projects/ParaView/Python/foo.png', magnification=1, quality=100, view=quartileChartView1)
#SaveData('/home/jfavre/Projects/ParaView/Python/foo.csv', proxy=plot)

