# Demonstration script for paraview version 5.4
# written by Jean M. Favre, Swiss National Supercomputing Centre
# tested Mon Jul 10 08:12:22 CEST 2017

#### import the simple module from the paraview
from paraview.simple import *
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

# Create a new 'Render View'
viewSG = GetRenderView()

ReqDataScript = """
import numpy as np
from vtk.numpy_interface import algorithms as algs
from vtk.numpy_interface import dataset_adapter as dsa

executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
exts = [executive.UPDATE_EXTENT().Get(outInfo, i) for i in range(6)]
whole = [executive.WHOLE_EXTENT().Get(outInfo, i) for i in range(6)]

dims = np.array([exts[1]-exts[0]+1, exts[3]-exts[2]+1, exts[5]-exts[4]+1])
global_dims = ([whole[1]-whole[0]+1, whole[3]-whole[2]+1, whole[5]-whole[4]+1])
print("global_dims =", global_dims)
print("exts =", exts)
output.SetExtent(exts)

Zaxis = np.linspace(0., 2., global_dims[0])[exts[0]:exts[1]+1]
Thetaaxis = np.linspace(0.,np.pi*0.5, global_dims[1])[exts[2]:exts[3]+1]
Raxis = np.linspace(1., 2.0, global_dims[2])[exts[4]:exts[5]+1]

r, t, z = np.meshgrid(Raxis, Thetaaxis, Zaxis, indexing="ij")
X = r * np.cos(t)
Y = r * np.sin(t)
Z = z

coordinates = algs.make_vector(X.ravel(),Y.ravel(),Z.ravel())
output.Points = coordinates
output.PointData.append(r.ravel(), "radius")
output.PointData.append(t.ravel(), "theta")
output.PointData.append(z.ravel(), "z-elevation")
"""

ReqInfoScript = """
executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
# A 3D cylindrical mesh
# fastest moving axis is the Z. See attached image Cylindrical_fastestz.png
dims = [13,27,3] # z-elevation, theta, radius
outInfo.Set(executive.WHOLE_EXTENT(), 0, dims[0]-1 , 0, dims[1]-1 , 0, dims[2]-1)
outInfo.Set(vtk.vtkAlgorithm.CAN_PRODUCE_SUB_EXTENT(), 1)
"""

# create a new 'Programmable Source'
programmableSource1 = ProgrammableSource()
programmableSource1.OutputDataSetType = 'vtkStructuredGrid'
programmableSource1.Script = ReqDataScript
programmableSource1.ScriptRequestInformation = ReqInfoScript
programmableSource1.PythonPath = ''

rep2 = Show()
rep2.Representation = 'Surface With Edges'
Render()
viewSG.ResetCamera()
Render()
