# Demonstration script for paraview version 5.0
#
# Creates a spherical grid with a Python ProgrammableSource.
# Works also in parallel by splitting the extents
#
# written by Jean M. Favre, Swiss National Supercomputing Centre
#
# See http://mathworld.wolfram.com/SphericalCoordinates.html

from paraview.simple import *
paraview.simple._DisableFirstRenderCameraReset()

viewSG = GetRenderView()

ReqDataScript = """
import numpy as np
from vtk.numpy_interface import algorithms as algs

executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
exts = [executive.UPDATE_EXTENT().Get(outInfo, i) for i in range(6)]
whole = [executive.WHOLE_EXTENT().Get(outInfo, i) for i in range(6)]

global_dims = ([whole[1]-whole[0]+1, whole[3]-whole[2]+1, whole[5]-whole[4]+1])

output.SetExtent(exts)

Raxis = np.linspace(1., 2., global_dims[0])[exts[0]:exts[1]+1]
# only use 3/4 of the full longitude in order to view the inside of the sphere
Thetaaxis = np.linspace(0.,np.pi*1.5, global_dims[1])[exts[2]:exts[3]+1]
Phiaxis = np.linspace(0.,np.pi*1.0, global_dims[2])[exts[4]:exts[5]+1]

p, t, r = np.meshgrid(Phiaxis, Thetaaxis, Raxis, indexing="ij")
X = r * np.cos(t) * np.sin(p)
Y = r * np.sin(t) * np.sin(p)
Z = r * np.cos(p)

output.Points = algs.make_vector(X.ravel(),Y.ravel(),Z.ravel())
output.PointData.append(r.ravel(), "radius")
output.PointData.append(t.ravel(), "theta")
output.PointData.append(p.ravel(), "phi")
"""

ReqInfoScript = """
executive = self.GetExecutive()
outInfo = executive.GetOutputInformation(0)
# A 3D spherical mesh
dims = [3, 9, 7] # radius, theta(longitude), phi(latitude)
outInfo.Set(executive.WHOLE_EXTENT(), 0, dims[0]-1 , 0, dims[1]-1 , 0, dims[2]-1)
outInfo.Set(vtk.vtkAlgorithm.CAN_PRODUCE_SUB_EXTENT(), 1)
"""

programmableSource1 = ProgrammableSource()
programmableSource1.OutputDataSetType = 'vtkStructuredGrid'
programmableSource1.Script = ReqDataScript
programmableSource1.ScriptRequestInformation = ReqInfoScript

rep2 = Show()
rep2.Representation = 'Surface With Edges'
Render()

