
# tested with ParaView v5.4
# Fri Jun 30 14:49:17 CEST 2017
# Author: Jean M. Favre, CSCS
#
# run once, in parallel. No ghost-cells are available.
# Attempting to display the value of variable 'GhostType' fails because it is not available
# trigger a second execution by switching the contour.ComputeNormals to 1.
# the variable 'GhostType' becomes available.

try: paraview.simple
except: from paraview.simple import *

# testing can be done locally, using multi-core support, or connecting to a remote server

wav = Wavelet()
wav.WholeExtent = [0, 99, 0, 99, 0, 99]
#wav.UpdatePipeline()
rep1 = Show()
rep1.Representation = 'Outline'
ScalarRange = wav.PointData.GetArray(0).GetRange()

contour = Contour(Input=wav)
# setting ComputeNormals to 1 will trigger a request for ghost cells.
contour.ComputeNormals = 0
avg = (ScalarRange[0]+ScalarRange[1])*0.5
print "evaluating isosurface at threshold ", avg

contour.Isosurfaces = [avg]
contour.UpdatePipeline()

#id = ProcessIdScalars()
#id.UpdatePipeline()

pythonCalculator1 = PythonCalculator(Input=contour)
pythonCalculator1.Expression = 'inputs[0].PointData["vtkGhostType"]'
pythonCalculator1.ArrayAssociation = 'Point Data'
pythonCalculator1.ArrayName= 'GhostType'
pythonCalculator1.CopyArrays = 0

pythonCalculator1Display = Show()

ResetCamera()

#wri = servermanager.writers.XMLPUnstructuredGridWriter()
#wri.FileName="/tmp/foo.pvtu"
#wri.Input = id
#wri.UpdatePipeline()
SaveScreenshot("foo.png", ImageResolution=[1024,1024])

contour.ComputeNormals = 0
pythonCalculator1.UpdatePipeline()
pythonCalculator1Display.ColorArrayName = ('POINTS', 'GhostType')


#Render()
SaveScreenshot("foo2.png", ImageResolution=[1024,1024])

