// dépendances
var express = require('express');
var path = require('path');
var child_process = require('child_process');

// création du serveur
var server = express();

// dossier statique (tous les fichiers du 
// dossier pourront être chargés dans le navigateur)
server.use(express.static('client'));


// GET / : affichage de la page html
server.get('/', function (request, response) {
  response.sendFile(path.join(__dirname, 'client/index.html'));
  // sendFile nécessite un chemin absolu
});


// écoute des requêtes sur le port 8000
server.listen(8000, function () {
	console.log('Server now listening on port 8000');
});


// création du serveur de sockets
var io = require('socket.io').listen(8080);

// map socketId - processus de calcul
var processes = {};

// map socketId processus - socketId interface
var clientToPs = {};

// détection des connexions
io.on('connection', function (socket) {

    console.log('Connexion détectée');

    var clientId = socket.request._query.clientId;
    if (clientId) {
        // un calculateur s'est connecté
        clientToPs[clientId] = socket.id;
    }
    
    // détection des déconnexions
    socket.on('disconnect', function() {
        console.log('Déconnexion détectée');
        endCalc(socket.id);
    });

    // détection évènement 'hello'
    socket.on('hello', function (data) {
    	console.log('Message reçu : ' + data.message + 		' from ' + data.from);
    
    	// réponse à l'émetteur
    	// socket.emit('welcome', data.from);

    	// réponse à tous les clients
    	// io.emit('welcome', data.from);

    	// broadcast : réponse à tous les clients
    	// sauf l'émetteur
    	socket.broadcast.emit('welcome', data.from);

    });		

    // détection évènement 'launch_calc'
    socket.on('launch_calc', function () {
        launchCalc(socket.id);
    });

    // détection évènement 'end_calc'
    socket.on('end_calc', function () {
        endCalc(socket.id);
    });

    // détection évènement 'change_param'
    socket.on('change_param', function (param) {
        changeParam(socket.id, param);
    });

    // détection évènement 'data'
    socket.on('data', sendData);
});




// fonction lancement calcul
function launchCalc(socketId) {
    if (!processes[socketId]) {
        var cmd = 'python calcul.py ' + socketId;
        var ps = child_process.exec(cmd, function (error, stdout, stderr) { 
            console.log('Un processus s\'est terminé');
        });
        processes[socketId] = ps;
    }
}

// fonction envoi de données
function sendData(message) {
    io.to(message.clientId).emit('calc_data', message);
}

// fonction terminaison calcul
function endCalc(socketId) {
    var ps = processes[socketId];
    if (ps) {
        ps.kill('SIGTERM');
    }
}

// fonction changement de paramètre
function changeParam(socketId, param) {
    processSocketId = clientToPs[socketId];
    io.to(processSocketId).emit('change_param', param);
}