/*
 * trivial-client: TCP client connection to a server and receiving its own
 * name back.
 *
 * Loic Tortay, 2012.
 *
 */

#include <sys/types.h>
#include <sys/socket.h>

#define __USE_MISC
#include <errno.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "errwarn.h"

const char progname[] = "trivial-client";


int main(int argc, char *argv[])
{
	char			 hostname[NI_MAXHOST];
	struct addrinfo		 aih;
	struct addrinfo		*aip = NULL;
	ssize_t			 nr = 0;
	int			 cfd = -1;
	int			 reuse = 1, res = -1;

	if (argc != 3) {
		fprintf(stderr, "Usage:\n\t%s addr port\n", progname);
		exit (1);
	}

	memset(&aih, 0, sizeof(aih));
	/*
	 * AI_NUMERICSERV: port number must be a number not a service name.
	 */
	aih.ai_flags = AI_NUMERICSERV;
	/* AF_UNSPEC: accept IPv4 & IPv6 */
	aih.ai_family = AF_UNSPEC;
	/* Connected byte streams (TCP) */
	aih.ai_socktype = SOCK_STREAM;

	res = getaddrinfo(argv[1], argv[2], &aih, &aip);
	if (res != 0)
		error(1, -1, "Unable to find addr(%s): %s (%d)", argv[1],
		    gai_strerror(res), res);

	printf("Opening socket to %s:%s\n", argv[1], argv[2]);
	cfd = socket(aip->ai_family, aip->ai_socktype, aip->ai_protocol);
	if (cfd == -1)
		error(1, errno, "Unable to open TCP socket");

	/* Avoid coalescing of small segments, send immediatly. */
	reuse = 1;
	res = setsockopt(cfd, IPPROTO_TCP, TCP_NODELAY, &reuse, sizeof(reuse));
	if (res == -1)
		error(1, errno, "Unable to set TCP option (NODELAY)");

	res = connect(cfd, aip->ai_addr, aip->ai_addrlen);
	if (res == -1)
		error(1, errno, "Unable to connect to '%s' on port %s", argv[1],
		    argv[2]);

	nr = recv(cfd, hostname, sizeof(hostname), 0);
	if (nr == -1)
		error(1, errno, "Error receiving data");

	printf("Received: '%s'\n", hostname);

	res = shutdown(cfd, SHUT_RDWR);
	if (res == -1)
		warning(errno, "Error during shutdown");

	res = close(cfd);
	if (res == -1)
		warning(errno, "Error closing socket");

	freeaddrinfo(aip);

	return (0);
}

