/*
 * scpc.c: get the value of a few POSIX system variables.
 *
 * cc scpc.c -o scpc; ./scpc
 */

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define SYSCONF_GET_AND_PRINT(name)						\
	do {									\
		long sc;							\
		errno = 0;							\
		sc = sysconf(name); 						\
		if (sc == -1 && errno == EINVAL)				\
			fprintf(stderr, "Unknown value: '%s'\n", #name);	\
		else								\
			printf("sysconf(%s): %ld\n", #name, sc);		\
	} while (0)

#define PATHCONF_GET_AND_PRINT(path, name)					\
	do {									\
		long pc;							\
		errno = 0;							\
		pc = pathconf(path, name); 					\
		if (pc == -1 && errno == EINVAL)				\
			fprintf(stderr, "Unknown value: '%s'\n", #name);	\
		else								\
			printf("pathconf('%s', %s): %ld\n", path, #name, pc);	\
	} while (0)


int main(int argc, char *argv[])
{
	static char slash[] = "/";
	char *path = NULL;

	if (argc > 1)
		path = argv[1];
	else
		path = slash;

	SYSCONF_GET_AND_PRINT(_SC_IOV_MAX);
	SYSCONF_GET_AND_PRINT(_SC_ASYNCHRONOUS_IO);
	SYSCONF_GET_AND_PRINT(_SC_AIO_MAX);
	SYSCONF_GET_AND_PRINT(_SC_AIO_LISTIO_MAX);
	SYSCONF_GET_AND_PRINT(_SC_ADVISORY_INFO);
	SYSCONF_GET_AND_PRINT(_SC_FSYNC);
/*	SYSCONF_GET_AND_PRINT(_SC_FILE_LOCKING); */
	SYSCONF_GET_AND_PRINT(_SC_PRIORITIZED_IO);
	SYSCONF_GET_AND_PRINT(_SC_SYNCHRONIZED_IO);
	SYSCONF_GET_AND_PRINT(_SC_TYPED_MEMORY_OBJECTS);
	SYSCONF_GET_AND_PRINT(_SC_MAPPED_FILES);

	PATHCONF_GET_AND_PRINT(path, _PC_FILESIZEBITS);
	PATHCONF_GET_AND_PRINT(path, _PC_NAME_MAX);
	PATHCONF_GET_AND_PRINT(path, _PC_PATH_MAX);
	PATHCONF_GET_AND_PRINT(path, _PC_REC_INCR_XFER_SIZE);
	PATHCONF_GET_AND_PRINT(path, _PC_REC_MAX_XFER_SIZE);
	PATHCONF_GET_AND_PRINT(path, _PC_REC_MIN_XFER_SIZE);
	PATHCONF_GET_AND_PRINT(path, _PC_REC_XFER_ALIGN);
	PATHCONF_GET_AND_PRINT(path, _PC_ASYNC_IO);
	PATHCONF_GET_AND_PRINT(path, _PC_PRIO_IO);
	PATHCONF_GET_AND_PRINT(path, _PC_SYNC_IO);
	PATHCONF_GET_AND_PRINT(path, _PC_ALLOC_SIZE_MIN);

	return(0);
}

