/*
 * meat.c: allocate memory and make sure it's actually allocated by touching
 * (writing a byte in) all memory pages allocated.
 * When the memory allocation is done, the pages are touched in an endless
 * loop.
 *
 * Loic Tortay, 2006.
 *
 */

#include <errno.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int
main(int argc, char *argv[])
{
	char    *ptr = NULL;
	long int pagesize = 0L;
	size_t   n = 0, nbytes = 0, threshold = 0;

	if (argc != 2) {
		fprintf(stderr, "Size required (in bytes)\n");
		exit(1);
	}

	nbytes = (size_t) atoll(argv[1]);
	threshold = nbytes / 10;

	if ((pagesize = sysconf(_SC_PAGESIZE)) == -1)
		fprintf(stderr, "Unable to get memory page size: %s (%d)\n",
		    strerror(errno), errno);

	fprintf(stderr, "nbytes: %lu, pagesize: %lu\n", (unsigned long) nbytes,
	    (unsigned long) pagesize);

	if ((ptr = (char *) malloc(nbytes)) == NULL) {
		fprintf(stderr, "Failed to allocate %lu bytes of memory: %s "
		    "(%d)\n", (unsigned long) nbytes, strerror(errno), errno);
		exit(1);
	}

	for (;;) {
		/*
	 	 * Defeat overcommit/on demand paging by touching a single byte
		 * in each allocated page.
	 	 */
		for (n = 0L; n < nbytes; n += pagesize) {
			ptr[n] = 't';
			if (n % threshold == 0)
				fprintf(stderr, ".");
		}
		fprintf(stderr, "\n");

		/* Make sure all pages are touched. */
		if (n != nbytes)
			ptr[nbytes - (nbytes % pagesize) + 1] = 't';
	}

	return (0);
}

