#!/bin/ksh -ue

CAT=/bin/cat
DATE=/bin/date
PERL=/usr/bin/perl
PTIME=/usr/bin/ptime
RM=/bin/rm
TIME=/usr/bin/time

AENT=aio-ent
ALENT=aio-lio-ent
BENT=block-ent
CENT=cstream-ent
DBENT=dio-block-ent
MENT=mmap-ent
MCMENT=mmap-cond-munmap-ent
MOENT=mmap-off-ent
RABENT=ra-block-ent

if [ -x ${PTIME} ]; then
	RTIME="${PTIME}" ;
else
	RTIME="${TIME} -p";
fi

FILE="a600m";

echo "-- Creating: ${FILE} ($(${DATE}))";
set -x;
${RTIME} ${PERL} -le 'foreach $l ('A'..'Z', '0'..'9', 'a'..'z') {
	print "$l"x(1048576*10);
}' > ./${FILE};
set +x;

#
echo "-- Analyzing: ${FILE} ($(${DATE}))";
echo "-- The expected values are: '3870926492.63 bits, n = 63, avg(H): 5.95 bits'";
. ./_t.sh

