#define GET_CYCLES( res ) {					\
    unsigned long int low, high;				\
    __asm__ __volatile__("rdtsc" : "=a" (low), "=d" (high));	\
    res = (unsigned long long int)high << 32 | low;		\
}

static inline double wallclock(void)
{
  struct timeval tv;
  double t;

  gettimeofday(&tv, NULL);

  t = (double)tv.tv_sec;
  t += ((double)tv.tv_usec)/1000000.0;

  return t;
}



int * getSizes( int from, int to ) {
  // Compute number of samples
  int i, i_prev, nb_samples;
  for( i = from, nb_samples = 0, i_prev = 0 ; i <= to ; nb_samples++ ) {
    if( i_prev == 0 ) {
      i_prev = i;
      i = 2*i;
    }
    else {
      i += i_prev;
      i_prev = i - i_prev;
    }
  }

  int *sizes = malloc( sizeof(int)*(nb_samples+1) );
  sizes[nb_samples] = 0;

  // Compute range
  for( i = from, nb_samples = 0, i_prev = 0 ; i <= to ; nb_samples++ ) {
    sizes[nb_samples] = i;
    if( i_prev == 0 ) {
      i_prev = i;
      i = 2*i;
    }
    else {
      i += i_prev;
      i_prev = i - i_prev;
    }
  }
  return sizes;
}

int printGnuplotFile( const char *filename, const char *title, const char *plot ) {
  
  FILE *gp_file = fopen( filename, "w" );
  if( ! gp_file ) {
    perror( filename );
    return 0;
  }

#if 0
  fprintf( gp_file, "set key left top\n" );
#else
  fprintf( gp_file, "set key right bottom\n" );
  fprintf( gp_file, "set logscale y\n" );
#endif
  fprintf( gp_file, "set logscale x\n" );
  fprintf( gp_file, "set xlabel \"Number of elements\"\n" );
/*   fprintf( gp_file, "set ylabel \"Number of cycles per iteration\"\n" ); */
  fprintf( gp_file, "set ylabel \"MFLOPS\"\n" );
  fprintf( gp_file, "%s \"%s.dat\" title '%s' with linespoints\n", plot, title, title );

  fclose( gp_file );
  return 1;
}
