#define NB_FLOP(n) (2*n*n*n)

#define DATA_TYPE float

int init( int size, int seed, DATA_TYPE *alpha, DATA_TYPE *beta, DATA_TYPE **vin1, DATA_TYPE **vin2, DATA_TYPE **vout ) {
  *alpha = (DATA_TYPE)1.2;
  *beta = (DATA_TYPE)0.8;

  *vin1 = (DATA_TYPE *)calloc(size*size, sizeof(DATA_TYPE));
  if( ! *vin1 ) return 0;

  *vin2 = (DATA_TYPE *)calloc(size*size, sizeof(DATA_TYPE));
  if( ! *vin2 ) return 0;
  
  *vout = (DATA_TYPE *)calloc(size*size, sizeof(DATA_TYPE));
  if( ! *vout ) return 0;
  
  int i;
  for( i = 0 ; i < size*size ; i++ ) {
    (*vin1)[i] = (DATA_TYPE)(((int)(i+seed) % 5) + 2);
    (*vin2)[i] = (DATA_TYPE)(((int)(i)%7)+9);
    (*vout)[i] = (DATA_TYPE)(((int)(i)%6)+3);
  }
  return 1;
}
