/*
   A simple 2D hydro code
   (C) Romain Teyssier : CEA/IRFU           -- original F90 code
   (C) Pierre-Francois Lavallee : IDRIS      -- original F90 code
   (C) Guillaume Colin de Verdiere : CEA/DAM -- for the C version
   */

#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <stdio.h>

#include "parametres.h"
#include "utils.h"
#include "slope.h"

#ifndef HMPP

#define DABS(x) (double) fabs((x))
#define IDX(i,j,k) ( (i*Hstep*Hnxyt) + (j*Hnxyt) + k )

void slope (const int n,
        const int Hnvar,
        const int Hnxyt,
        const double Hslope_type,
        const int slices, const int Hstep, double *q, double *dq)
{
    //WHERE ("slope");

    double dlft, drgt, dcen, dsgn, slop, dlim;
    int  ijmin, ijmax;
    ijmin = 0;
    ijmax = n;
#pragma hmppcg gridify(nbv,s)
    for (int nbv = 0; nbv < Hnvar; nbv++)
    {
        for (int s = 0; s < slices; s++)
        {
            for (int i = ijmin + 1; i < ijmax - 1; i++)
            {
                dlft = Hslope_type * (q[IDX (nbv, s, i)]      - q[IDX (nbv, s, i - 1)]);
                drgt = Hslope_type * (q[IDX (nbv, s, i + 1)]  - q[IDX (nbv, s, i)]);
                dcen = half * (dlft + drgt) / Hslope_type;
                dsgn = (dcen > 0) ? (double) 1.0 : (double) -1.0;	// sign(one, dcen);
                slop = fmin (fabs (dlft), fabs (drgt));
                dlim = slop;
                if ((dlft * drgt) <= zero){
                    dlim = zero;
                }

                dq[IDX(nbv, s, i)] = dsgn * fmin (dlim, fabs (dcen));

#ifdef FLOPS
                flops += 8;
#endif
            }
        }
    }
}				// slope

//#undef IHVW
#undef IDX

#endif /* HMPP */
//EOF
