#ifndef RIEMANN_H_INCLUDED
#define RIEMANN_H_INCLUDED

#include "hmpp.h"


#pragma hmpp Hriemann codelet, &
#pragma hmpp &        target=CUDA, &
#pragma hmpp &        args[qleft,qright].io=in, &
#pragma hmpp &        args[qgdnv,sgnm].io=out, &
#pragma hmpp &        args[qleft,qright,qgdnv,sgnm].mirror, &
#pragma hmpp &        args[0-8].transfer=atcall, &
#pragma hmpp &        args[9-12].transfer=manual
void riemann (int narray,
        const double Hsmallr,
        const double Hsmallc,
        const double Hgamma,
        const int Hniter_riemann,
        const int Hnvar,
        const int Hnxyt,
        const int slices, const int Hstep,
        double *qleft, double *qright, double *qgdnv, int *sgnm);


#pragma hmpp HDmemset codelet, &
#pragma hmpp &        target=CUDA, &
#pragma hmpp &        args[t].mirror, &
#pragma hmpp &        args[nbr,motif].transfer=atcall, &
#pragma hmpp &        args[t].transfer=manual
void Dmemset (size_t nbr, double t[nbr], double motif);

#endif // RIEMANN_H_INCLUDED
