#ifndef CONSERVAR_H_INCLUDED
#define CONSERVAR_H_INCLUDED


#pragma hmpp Hgatherconservar codelet, &
#pragma hmpp &                target=CUDA, &
#pragma hmpp &                args[uold,u].mirror, &
#pragma hmpp &                args[0-11].transfer=atcall, &
#pragma hmpp &                args[uold,u].transfer=manual
void gatherConservativeVars (const int idim,
        const int rowcol,
        const int Himin,
        const int Himax,
        const int Hjmin,
        const int Hjmax,
        const int Hnvar,
        const int Hnxt,
        const int Hnyt,
        const int Hnxyt,
        const int slices, const int Hstep,
        double *uold, double *u);


#pragma hmpp Hupdateconservar codelet, &
#pragma hmpp &                target=CUDA, &
#pragma hmpp &                args[u,flux,uold].mirror, &
#pragma hmpp &                args[0-12].transfer=atcall, &
#pragma hmpp &                args[uold,u,flux].transfer=manual
void updateConservativeVars (const int idim,
        const int rowcol,
        const double dtdx,
        const int Himin,
        const int Himax,
        const int Hjmin,
        const int Hjmax,
        const int Hnvar,
        const int Hnxt,
        const int Hnyt,
        const int Hnxyt,
        const int slices, const int Hstep,
        double uold[Hnvar * Hnxt * Hnyt],
        double *u, double *flux);

#endif // CONSERVAR_H_INCLUDED
