
#include "common.h"
#include "mkv.h"

const QUAD encaps[]={ID_EBML, ID_SEGMENT, ID_INFO,\
                     ID_TRACKS, ID_TRACKENTRY, ID_VIDEO};

const QUAD skips[]={ID_SEEKHEAD, ID_VOID};


/*****************************************************************/
inline DWORD read_vint(BYTE* buffer, unsigned int *pos, bool ID) {
    QUAD vint=0;
    unsigned int length=0;
    unsigned int i;

    if (buffer[*pos] == 0) {
	fprintf(stderr,"NULL vint: this should never happen!\n");
	exit(1);
    }

    while (buffer[*pos]<0x80) {
	buffer[*pos] <<= 1;
	length++;
    }
    if (!ID) 
	buffer[*pos] ^= 0x80;
    buffer[*pos] >>= length;

    for(i=0; i<=length; i++) {
	memcpy(((BYTE*)&vint)+i, buffer+*pos+length-i, 1);
    }
    *pos += length+1;

    return vint;
}


/*************************************************/
void parse_ebml_id(char* filename, mkvData *info) {
    BYTE buffer[1024];
    DWORD ebml_ID;
    DWORD size;
    int done=0;
    int encapsulating=0;
    unsigned int i;

    FILE *mkvfile = fopen(filename, "r");
    unsigned long int file_pos=0;

    while (fread(buffer, sizeof(buffer), 1, mkvfile) == 1) {
	unsigned int pos=0;
	while (1) {
	    if ((pos+8)>sizeof(buffer)) {
		fprintf(stderr,"End of buffer\n");
		break;
	    }
	    ebml_ID=read_vint(buffer,&pos,1);
	    size=read_vint(buffer,&pos,0);

	    if ((ebml_ID == ID_SEEKHEAD) || (ebml_ID == ID_VOID)) {
		file_pos += size;
		break;
	    }

	    encapsulating=0;
	    for (i=0; i<=sizeof(encaps); i++) {
		if (ebml_ID == encaps[i]) {
		    encapsulating=1;
		}
	    }
	    if (encapsulating)
		continue;

	    if ((pos+size)>=sizeof(buffer)) {
		break;
	    }

	    switch (ebml_ID) {
		case ID_DURATION:
		    for(i=0; i<size; i++) {
			memcpy(((BYTE*)&info->duration)+i, buffer+pos+size-1-i, 1);
		    }
		    done++;
		    break;
		case ID_WIDTH:
		    for(i=0; i<size; i++) {
			memcpy(((BYTE*)&info->width)+i, buffer+pos+size-1-i, 1);
		    }
		    done++;
		    break;
		case ID_HEIGHT:
		    for(i=0; i<size; i++) {
			memcpy(((BYTE*)&info->height)+i, buffer+pos+size-1-i, 1);
		    }
		    done++;
		    break;
		    /*	    case ID_ENCODER:
			    done++;
			    break;
		    */
		default:
		    ;
	    }
	    pos+=size;
	    if (done>=3) {
		fclose(mkvfile);
		return;
	    }
	}
	file_pos += pos;
	if (fseek(mkvfile, file_pos, SEEK_SET) != 0) {
	    fprintf(stderr,"FSEEK error: %s\n", strerror(errno));
	}
    }
    fprintf(stderr,"Fin du fichier %s\n",filename);
    fclose(mkvfile);
    exit(2);
}

/*********************************/
void get_mkv_info(char* filename) {
    struct stat stats;
    mkvData mkvInfo;
    char duree[16];

    if ( stat(filename, &stats) != 0 ) {
	fprintf (stderr, "%s : erreur en lisant la taille.\n", filename);
	exit (1);
    }

    parse_ebml_id(filename,&mkvInfo);

    sec_to_str((int)(mkvInfo.duration/1000), duree);

    printf("<< %s >> : %ld Mo pour %s, %dx%d   %s\n", filename,\
	   stats.st_size/1024/1024, duree,\
	   mkvInfo.width, mkvInfo.height,\
	   mkvInfo.encoder); 
}
