
#include "common.h"
#include "avi.h"

/*********************************/
void get_avi_info(char* filename) {
    MainAVIHeader header;
    char encoder[5];
    char decoder[5];
    struct stat stats;
    char duree[16];
    int result;

    FILE *avifile = fopen(filename, "r");

    fseek(avifile, HEADER_SEEK, SEEK_SET);
    fread(&header, sizeof(header), 1, avifile);
/*    if (header.dwRate == 0) {
	printf("%s : Erreur en lisant le header !\n",filename);
	return;
    }
*/

    fseek(avifile, ENCODER_SEEK, SEEK_SET);
    fread(encoder, 4, 1, avifile);
    encoder[4]='\0';
	
    if (fseek(avifile, DECODER_SEEK, SEEK_SET) != 0) {
	printf("%s : INCOMPLET !\n", filename);
	return;
    }
    fread(decoder, 4, 1, avifile);
    decoder[4]='\0';

    result = stat(filename, & stats);
    if ( result != 0 ) {
	fprintf (stderr, "%s : erreur\n", filename);
	exit (1);
    }

    sec_to_str((unsigned long int)(1.0*header.dwMicroSecPerFrame*header.dwTotalFrames/1000000), duree);

    printf("<< %s >> : %ld Mo pour %s, %ldx%ld, codecs %s - %s\n", filename,\
		stats.st_size/1024/1024, duree,\
		(unsigned long int)header.dwWidth, (unsigned long int)header.dwHeight,\
		encoder, decoder);

    fclose(avifile);
}

