#ifndef OGG_H
#define OGG_H

#include "common.h"
#include "timedisp.h"

void get_ogm_info(char* filename);

#define OGGHEADER_SEEK 0
#define OGGVHEADER_SEEK 27
#define OGGHEADEREND_SEEK 50

struct MainOggHeader {
    char	capture_pattern[4];	/* "OggS" */
    BYTE	stream_structure_version;
    BYTE	header_type_flag;
    QUAD	granule_position;
    DWORD	bitstream_serial_number;
    DWORD	page_sequence_number;
    DWORD	CRC_checksum;
    BYTE	number_page_segments;
} __attribute__((packed));

struct OggVideoHeader {
    BYTE	init;		/* \01 */
    char	stream_type[8];	/* "video\0\0" */
    char	codec_fourcc[4];
    DWORD	struct_size;
    QUAD	time_unit;
    QUAD	samples_per_unit;
    DWORD	default_length;
    DWORD	buffer_size;
    DWORD	bits_per_sample;
    DWORD	dwWidth;
    DWORD	dwHeight;
    QUAD	unknown;
} __attribute__ ((packed));

#endif
