
#include "common.h"
#include "ogm.h"

/*********************************/
void get_ogm_info(char* filename) {
    struct MainOggHeader header;
    struct OggVideoHeader Vheader;
    char encoder[5];
    struct stat stats;
    int result;

    FILE *ogmfile = fopen(filename, "r");

    fseek(ogmfile, OGGHEADER_SEEK, SEEK_SET);
    fread(&header, sizeof(header), 1, ogmfile);

    fseek(ogmfile, OGGVHEADER_SEEK+header.number_page_segments, SEEK_SET);
    fread(&Vheader, sizeof(Vheader), 1, ogmfile);
    strncpy(encoder,Vheader.codec_fourcc, sizeof(Vheader.codec_fourcc));
    encoder[4]='\0';

    if (fseek(ogmfile, OGGHEADEREND_SEEK, SEEK_SET) != 0) {
	printf("%s : INCOMPLET !\n", filename);
	return;
    }

    result = stat(filename, & stats);
    if ( result != 0 ) {
	fprintf (stderr, "%s : erreur\n", filename);
	exit (1);
    }

    printf("<< %s >> : %ld Mo, %dx%d - %s\n", filename,\
		stats.st_size/1024/1024,\
		Vheader.dwWidth, Vheader.dwHeight,\
		encoder);

    fclose(ogmfile);
}

