      program laplace
!
      IMPLICIT NONE
!
      Integer,  Parameter  ::  rp = Kind (1.0d0)
!
      Real(rp),  Allocatable, Dimension(:)  ::  xm
      Real(rp),  Allocatable, Dimension(:)  ::  ym
!
      Real(rp),  Allocatable, Dimension(:)  ::  x
      Real(rp),  Allocatable, Dimension(:)  ::  y
!
      Real(rp),  Allocatable, Dimension(:,:)  ::  V, V_old
      Real(rp),  Allocatable, Dimension(:,:)  ::  eps
      Real(rp),  Allocatable, Dimension(:,:)  ::  vw, vs, vn, ve
      Real(rp),  Allocatable, Dimension(:,:)  ::  vc, sou

      Integer(rp),  Allocatable, Dimension(:,:)  ::  n_a
!
      Real(rp)  ::  distx, disty, dxx, dyy
      Real(rp)  ::  eps0, epsR, uc, ua, erreur_tol
      Real(rp)  ::  omega, omega1, erreur, erreur_max

      Integer   ::  nx, ny, ii, jj
      Integer   ::  i, j, k, iter_max, ierr
      Integer   ::  idielg, idield, nxdg, nxdd

      Integer   ::  i1, i2, i3, i4, ipoly, ik, itype
      Integer   ::  n_cell, n_cell_1, n_poly
      Real(rp)  ::  za

!
!-------------------
! Debut du programme
!-------------------
!      READ (5,*) nx, ny, iter_max, erreur_tol

      nx=100
      ny=100
      iter_max=100000
      erreur_tol=1.d-8

!
! "Gros" parametres d'execution
!     nx=1920
!     ny=1920
!     iter_max=5000
!     erreur_tol=1.0d-5
!
! "Petits" parametres d'execution
!     nx=1920
!     ny=1920
!     iter_max=5000
!     erreur_tol=1.0d-8

!Allocation des tableaux
      ALLOCATE (xm(0:nx), ym(0:ny), x(nx), y(ny), V(0:nx+1,0:ny+1), V_old(0:nx+1,0:ny+1),
     &          eps(0:nx+1,0:ny+1), vn(nx,ny), ve(nx,ny), vs(nx,ny), vw(nx,ny), vc(nx,ny),
     &          sou(nx,ny), n_a(0:nx,0:ny), STAT=ierr)
      IF (ierr /= 0) THEN
         Write (6,'(A)') 'ERREUR ALLOCATION DYNAMIQUE'
         STOP
      END IF

!------------------------------------                    
! discretisaton du domaine de calcul
!------------------------------------    
      erreur_max = 0.0d0
      distx = 1.0d0
      disty = 1.0d0
!    
      xm(0) = 0.0d0
      dxx = distx / Real(nx,rp)
      do i = 1, nx
         xm(i) = xm(i-1) + dxx
         x (i) = (xm(i) + xm(i-1) ) * 0.5d0
      end do
!   
      ym(0) = 0.0d0
      dyy = disty / Real(ny,rp)
      do j = 1, ny
         ym(j) = ym(j-1) + dyy
         y(j) = (ym(j) + ym(j-1) ) * 0.5d0
      end do
      
!------------------------------------------------        
! initialisation des parametres et des variables
!------------------------------------------------
      eps0 = 8.85d-14  !permittivite (F/cm)   
!
      do j = 0, ny+1
         do i = 0, nx+1
            V    (i,j) = 0.0d0
            V_old(i,j) = 0.0d0
            eps(i,j) = eps0
         end do
      end do


! choix des valeurs des potentiels fixes a gauche (uc) et a droite (ua)
      uc = 0.0d0
      ua = 1.0d0

! prise en compte des dielectriques 1 = oui ou 0 = non
      idielg = 1
      idield = 1

      nxdg = 11   ! epaisseur a gauche nxdg-1 mailles
      nxdd = 90   ! epaisseur a droite nx-nxdd mailles
      epsR = 5.0d0
!
      if (idielg == 1) then
         write (6,*) 'dielectrique a gauche jusqu a ', xm(nxdg-1)
         do j = 1, ny
            do i = 1, nxdg-1
                eps(i,j) = eps0 * epsR
            end do
         end do
      end if
!
      if (idield == 1) then
         write(6,*)'dielectrique a droite depuis ', xm(nxdd)
         do j = 1, ny
            do i = nxdd+1, nx
                eps(i,j) = eps0 * epsR
            end do
         end do
      end if

!-------------------------------------
! Resolution de l'equation de Laplace
!-------------------------------------
 
! choix du critere de convergence
!     erreur_tol = 1.0d-8

! choix de la methode de resolution
! omega = 1 : Gauss-Seidel
! 1<omega<2 : Sur-relaxation
      omega = 1.5d0
      omega1 = 1.0d0 - omega 

! Definition des coefficients de l'equation de Laplace
! cas general
      do j = 1, ny
         do i = 1, nx
            ve(i,j) = 2.0d0 * eps(i,j) * eps(i+1,j  ) / ( (eps(i,j) + eps(i+1,j) ) * dxx**2)
            vn(i,j) = 2.0d0 * eps(i,j) * eps(i  ,j+1) / ( (eps(i,j) + eps(i,j+1) ) * dyy**2)
            vs(i,j) = 2.0d0 * eps(i,j) * eps(i  ,j-1) / ( (eps(i,j) + eps(i,j-1) ) * dyy**2)
            vw(i,j) = 2.0d0 * eps(i,j) * eps(i-1,j  ) / ( (eps(i,j) + eps(i-1,j) ) * dxx**2)
            vc(i,j) = omega / ( vw(i,j) + vn(i,j) + vs(i,j) + ve(i,j) )
            sou(i,j) = 0.0d0
         end do
      end do

! Conditions aux limites de Neumann en j = 1 et j = ny
      j = 1
      do i = 1, nx
         vs(i,j) = 0.0d0
         vc(i,j) = omega / ( vw(i,j) + vn(i,j) + vs(i,j) + ve(i,j) )
      end do

      j = ny
      do i = 1, nx
         vn(i,j) = 0.0d0
         vc(i,j) = omega / ( vw(i,j) + vn(i,j) + vs(i,j) + ve(i,j) )
      end do

! Conditions aux limites de Dirichlet en i = 1 et i = nx
      i = 1
      do j = 1, ny
         vw(i,j) = 2.0d0*eps(i,j) / (dxx)**2
         vc(i,j) = omega / ( vw(i,j) + vn(i,j) + vs(i,j) + ve(i,j) )
         sou(i,j) = vw(i,j) * uc
         vw(i,j) = 0.0d0
      end do
 
      i = nx
      do j = 1, ny
         ve(i,j) = 2.0d0 * eps(i,j) / (dxx)**2
         vc(i,j) = omega / ( vw(i,j) + vn(i,j) + vs(i,j) + ve(i,j) )
         sou(i,j) = ve(i,j) * ua
         ve(i,j) = 0.0d0
      end do
 
 
! resolution sur k iterations
      do k = 1, iter_max
!
! Mise en memoire des potentiels a chaque iteration
         do j = 1, ny
            do i = 1, nx
               V_old(i,j) = V(i,j)
            end do
         end do

! Resolution de l'equation de Laplace
         do j = 1, ny
            do i = 1, nx
               V(i,j) = omega1 * V_old(i,j)
     &                + ( sou(i,j)
     &                  + ve(i,j) * V(i+1,j  ) + vw(i,j) * V(i-1,j  )
     &                  + vn(i,j) * V(i  ,j+1) + vs(i,j) * V(i  ,j-1) ) * vc(i,j)
            end do
         end do
 
! calcul du critere de convergence
         erreur_max = 0.0d0
         do j = 1, ny
            do i = 1, nx
               erreur = abs (V(i,j) - V_old(i,j) )
               erreur_max = max (erreur_max, erreur)
            end do
         end do
 
! critere d'arret 
         if (erreur_max < erreur_tol) then
            write (6,*) 'erreur_max ', erreur_max, ' it ', k
            go to 10
         end if
  
         if ( MOD(k, 100) == 0) then
            write (6,*) 'k = ', k, ' erreur = ', erreur_max
         end if
      end do

      write (6,*) 'erreur finale ', erreur_max, ' it ', iter_max
10    continue 

!---------------------
! sortie des resultats
!---------------------
!      open (unit=41,file='Potentiel2D.dat',status='unknown',form='formatted')
!      write (41,'(3ES12.5)') ( ( x(i), y(j), V(i,j), j=1,ny), i=1,nx)
!      close (41)
!
!      open (unit=44,file='Potentiel1D.dat',status='unknown',form='formatted')
!      j = nx /2
!      write (44,*) (x(i), V(i,j), i = 1, nx)
!      close (44)

!---------------------
! sortie des resultats
!---------------------
      open(unit=1,file='Potentiel2D.dat')
      do i=1,nx
        do j=1,ny
           write(1,*) x(i),y(j),V(i,j)
        enddo
        write(1,'(a)')
      enddo
    	close(1)     
       
      open(unit=44,file='Potentiel1D.dat')
      j=ny/2
      do i=1,nx
        write (44,*) x(i),V(i,j)
      enddo
	  close(44)       

!-----------------------------------
! sortie des resultats au format VTK
!-----------------------------------
      za=0.e0 ! visualisation en 2D
      n_cell=nx*ny
      n_cell_1=(nx+1)*(ny+1)
      n_poly=5*n_cell

      open (unit=10,status='unknown',file='potentiel0.vtk')

      write(10,*) '# vtk DataFile Version 2.0'
      write(10,*) 'Potentiel V'
      write(10,*) 'ASCII'
      write(10,*) ' '
      write(10,*) 'DATASET UNSTRUCTURED_GRID'
      write(10,*) 'POINTS', n_cell_1, ' float'

      k=0      
      do i=0,nx
        do j=0,ny
          write(10,*) xm(i),ym(j),za
          n_a(i,j)=k
          k=k+1
        enddo
      enddo
      
      write(10,*) ' '     
      write(10,*) 'CELLS', n_cell, n_poly
      do i=0,nx-1
        do j=0,ny-1
          ipoly=4
          i1=n_a(i,j)
          i2=n_a(i+1,j)
          i3=n_a(i+1,j+1)
          i4=n_a(i,j+1)
          write(10,*)ipoly,i1,i2,i3,i4
        enddo
      enddo
      
      itype=9            
      write(10,*) ' '
      write(10,*) 'CELL_TYPES', n_cell
      do ik=1,n_cell
        write(10,*) itype
      enddo



      write(10,*) ' '
      write(10,*) 'CELL_DATA', n_cell
      write(10,*) 'SCALARS cell_scalars float 1'
      write(10,*) 'LOOKUP_TABLE default'


      do i=1,nx
        do j=1,ny
          write(10,*) V(i,j)
        enddo
      enddo   

      close(10)

!
!Liberation des ressources
      DEALLOCATE (xm, ym, x, y, V, V_old, eps, vn, ve, vs, vw, vc, sou)
!
      stop
      end program laplace
