!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.

      program matrix_multiplication

! Code to illustrate example given in talk
! (c) Manchester Computing  Spring 1999
! Michael Bane (michael.bane@man.ac.uk)

      implicit none

      integer n
      !parameter (n=2048)
      parameter (n=256)
      !parameter (n=350)

      real a(n,n), b(n,n), c(n,n)

      integer counter, counter2
      integer i,j,k

      integer num_pes
      double precision start, finish, time_taken, timef

! initialize a, b and c
      call initial(b,c,n)
      call zero(a,n)

      start=timef()

#ifdef _A
        print *,"ijk"
      do i=1,n
         do j=1,n
            do k=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

#ifdef _B
        print *,"ikj" ! WORST
      do i=1,n
            do k=1,n
         do j=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

#ifdef _C
        print *,"jik"
         do j=1,n
      do i=1,n
            do k=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

#ifdef _D
        print *,"jki"
         do j=1,n
            do k=1,n
      do i=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

#ifdef _E
        print *,"kij" ! WORST
            do k=1,n
      do i=1,n
         do j=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

#ifdef _F
        print *,"kji"
            do k=1,n
         do j=1,n
      do i=1,n
               a(i,j) = a(i,j) + b(i,k)*c(k,j)
            end do
         end do
      end do
#endif

!$      num_pes=omp_get_num_threads()


      finish=timef()

      time_taken = finish-start

!$    print*, time_taken, "ms on ",num_pes," threads"
      !print*, time_taken, "sec"
      write(*,'(a2,f8.2,a4)'), 't=',time_taken,' sec'

      end

!

      subroutine initial(a,b,size)
      
      integer size, i,j
      real a(size,size), b(size,size)


      do j=1,size
         do i=1,size
            a(i,j) = float(i+j)
            b(i,j) = a(i,j) * float(i)
         end do
      end do

      return
      end

!
      subroutine zero(a,size)
      
      integer size, i,j
      real a(size,size)

      do j=1,size
         do i=1,size
            a(i,j) = 0.0
         end do
      end do

      return
      end


      function timef()
        real :: timef
        call cpu_time(timef)
        !timef = timef * 1000
      end
        

