!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.

program who 
!$      use omp_lib
        implicit none
#ifdef _MPI
        !use mpi 
        include "mpif.h"
#endif
        integer :: rank=-1,nb_procs=-1,code=-1,thread=-1,threads=-1
        integer ::  namelen=-1, coreid=-1
        character(len=2) :: processor_name=""
        integer, external :: running_on
 
#ifdef _MPI
        call MPI_INIT (code)
        call MPI_COMM_SIZE ( MPI_COMM_WORLD ,nb_procs,code)
        call MPI_COMM_RANK ( MPI_COMM_WORLD ,rank,code)
        call MPI_Get_processor_name( processor_name, namelen, code )
#endif

!$omp parallel private(thread)
!$      thread = omp_get_thread_num()
!$      threads = omp_get_num_threads()
        coreid = running_on()
        write (*,'(a17,i4,a2,i4,a5,i4,a2,i4,1x,a2,i4)') &
                "hello in f90 rnk=",&
                rank," /",nb_procs,&
                " thd=",thread," /",threads, &
                processor_name, &
                coreid
!$omp end parallel


#ifdef _MPI
        call MPI_FINALIZE (code)
#endif

end program who 
