/*
    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdlib.h>
#include <sched.h>

#include <stdio.h>
#include <unistd.h>
#include <string.h>
//#include <mpi.h>

// c
int running_on()
{
  unsigned long mask = 7;
  unsigned int len = sizeof(mask);
  pid_t pid = 0;                 /* The current process */
  int ret;
  int processor = -1;

  ret = sched_getaffinity (pid, len, &mask);

  while (mask > 0) {
    processor++;
    mask = mask >> 1;
  }
  return processor;
}

// fortran
int running_on_()
{
  return running_on();
}
