      PROGRAM LU
!
!$    USE OMP_LIB

      IMPLICIT NONE
!
      Integer,  Parameter  ::  rp = Kind (1.0d0)
!
      Real(rp),  Allocatable, Dimension(:,:,:)  ::  V

      Integer   :: nx, ny, nz, i, j, k

!$    Integer, Dimension(64) ::  isync

      Integer   :: mytid, nthread

      nx = 32
      ny = 32
      nz = 10

! Allocation des tableaux
      ALLOCATE ( V(1:nx,1:ny,1:nz) )

! Initialisation de la Matrice
      V(:,:,:)=0

      Do j=1,ny 
         Do i=1, nx
           if (i .le. (ny-j)) then
              V(i,j,1) = (1.d-5 * i)/nx
           endif
         end do
      end do

!$OMP PARALLEL DEFAULT(NONE) SHARED (V, nx, ny, nz, isync) PRIVATE (i, j, k, mytid, nthread)

! Connaitre mon numero de thread
!$     mytid = OMP_GET_THREAD_NUM()
! Connaitre le nombre de threads
!$     nthread = OMP_GET_NUM_THREADS()
      
! Initialiser un tableau pour la synchro entre voisins
!$     isync(mytid) = 0

!$OMP FLUSH(isync)

! Synchronisation entre toutes les threads avant de poursuivre
!$OMP BARRIER

      do k=2, nz

!$        if (mytid .gt. 0) then
!$            do while ( isync(mytid - 1) .eq. 0 )
!$OMP FLUSH(isync)
!$            enddo
!$            isync(mytid - 1) = 0
!$OMP FLUSH(isync,V)
!$        end if

!$OMP DO SCHEDULE(STATIC)
         do j=2, ny
            do i = 2, nx
               V(i, j, k) = V(i, j, k)  + V(i-1, j, k) + V(i, j-1, k) + V(i, j, k-1)
            end do
         end do
!$OMP END DO NOWAIT


! Indique a la thread suivante la disponibilite des donnees sauf pour la derniere thread
!$         if ( mytid .lt. (nthread - 1) ) then
!$OMP FLUSH (isync,V)
!$            do while ( isync(mytid) .eq. 1)
!$OMP FLUSH (isync)
!$            end do
!$            isync(mytid) = 1
!$OMP FLUSH (isync)
!$         end if

      end do

!$OMP END PARALLEL 
     
      open (unit=41,file='LU.dat',status='unknown',form='formatted')
      write (41,'(3ES12.5)') ( ( V(i,j,nz), j=1,ny), i=1,nx)
      close (41)

      DEALLOCATE (V)

      END PROGRAM LU

