      PROGRAM MxV
!
!$    USE OMP_LIB

      IMPLICIT NONE
!
      Integer,  Parameter  ::  rp = Kind (1.0d0)
!
      Real(rp),  Allocatable, Dimension(:,:)  ::  M
      Real(rp),  Allocatable, Dimension(:)  ::  V, W

      Integer   :: nx, ny, i, j

      Integer   :: mytid, nthread

      nx = 32
      ny = 32

! Allocation des tableaux
      ALLOCATE ( M(1:nx, 1:ny) ,  V(1:nx) , W(1:nx) )

      V(1:nx)=1

      M(1:nx,1:ny) = 1

!$OMP PARALLEL DEFAULT(NONE) SHARED (M, V, W,  nx, ny) PRIVATE (i, j)

! Initialisation du calcul du  produit 
!$OMP SINGLE
      W(1:nx) = M(1:nx,1)*V(1)
!$OMP END SINGLE

!$OMP DO REDUCTION (+:W) 
         do j=2, ny
            do i = 1, nx
               W(i) = W(i) + M(i,j)*V(j)
            end do
         end do
!$OMP END DO NOWAIT

!$OMP END PARALLEL 
      write(6,*), (W(i), i = 1, nx)
      DEALLOCATE (M, V, W)


      END PROGRAM MxV

