      PROGRAM TOPOLOGIE
!

! Guy Moebs - CNRS
! Laboratoire de Mathematiques Jean Leray
! Universite de Nantes
!
! TP 3 : Crer une topologie et echanger lignes colonnes avec mes 4 points cardinaux
!
      USE mpi

      IMPLICIT NONE
!
! DECLARATION DES VARIABLES
!
      INTEGER,  DIMENSION(4,4)  ::  MOI, EUX
!
      INTEGER    ::  nbproc, myrank, i, j
      INTEGER    ::  icode
      INTEGER    ::  tag1, tag2
!
      INTEGER,  PARAMETER                  ::  NB_VOISINS = 4
      INTEGER,  DIMENSION(NB_VOISINS)      ::  voisin
      INTEGER,  PARAMETER                  ::  N=1, E=2
      INTEGER,  PARAMETER                  ::  S=3, W=4
!
      INTEGER,  DIMENSION(MPI_STATUS_SIZE)  ::  status
      INTEGER   ::  comm2d, colonne, ligne
      INTEGER,  DIMENSION(2)  ::  dims
      LOGICAL,  DIMENSION(2)  ::  periods
!
!===============================================================================
!===============================================================================
!
!     DEBUT DU PROGRAMME
!
!===============================================================================
!===============================================================================
!
      icode = 0
      tag1 = 100
      tag2 = 200
!
!Initialisation  de  MPI
      CALL  MPI_INIT (icode)
!
!Savoir  quel  processeur  je  suis
      CALL  MPI_COMM_RANK (MPI_COMM_WORLD, myrank, icode)
!
!Connaitre le nombre total de processeurs
      CALL  MPI_COMM_SIZE (MPI_COMM_WORLD, nbproc, icode)

!Connaitre
!  le nombre de processeurs selon x
!  le nombre de processeurs selon y
!  en fonction du nombre total de processeurs
      dims(1:2) = 0
      CALL MPI_DIMS_CREATE (nbproc, 2, dims, icode)
!
!Creation de la grille de processeurs 2D sans periodicite
      periods(1:2) = .FALSE.
!
      CALL MPI_CART_CREATE (MPI_COMM_WORLD, 2, dims, periods, .TRUE., comm2d, icode)
!
!Recherche de ses 4 voisins pour chaque processeur
!Initialisation du tableau voisin
      voisin(1:NB_VOISINS)  =  MPI_PROC_NULL
!
!Recherche des voisins Ouest et Est
      CALL  MPI_CART_SHIFT (comm2d, 0, 1, voisin(W), voisin(E), icode)
!
!Recherche des voisins Nord  et Sud
      CALL  MPI_CART_SHIFT (comm2d, 1, 1, voisin(S), voisin(N), icode)
!
      WRITE (6,'(7I4)') myrank, voisin(1:4), dims(1:2)
!
!Initialise les tableaux
      DO j = 1, 4
         DO i = 1, 4
            MOI(i,j) = 100*i + 1000 * j
            EUX(i,j) = 0
         END DO
      END DO
!
!Affiche les tableaux
      DO i = 1, 4
         WRITE (6,1010) (MOI(i,j),j=1,4), (EUX(i,j),j=1,4)
      END DO
 1010 FORMAT (4I6,10x,4I6)
      WRITE (6,*)

!Envoi au voisin W et reception du voisin  E
!en utilisant le type predefini colonne
      CALL MPI_TYPE_CONTIGUOUS( 
     &      3    ,                ! longueur d'un bloc
     &      MPI_INTEGER,          ! type initial
     &      colonne, icode)
      CALL MPI_TYPE_COMMIT (colonne, icode)
    
!Envoi au voisin N et reception du voisin  S
!en utilisant le type predefini ligne
!
      CALL MPI_TYPE_VECTOR (
     &      3,                 ! nombre de blocs
     &      1,                 ! longueur d'un bloc
     &      4,                 ! pas entre le debut de
     &      MPI_INTEGER,       ! deux blocs consecutifs
     &      ligne, icode)
      CALL MPI_TYPE_COMMIT (ligne, icode)

!Envoi au voisin N et reception du voisin S
!en utilisant le type predefini ligne
      CALL  MPI_SENDRECV ( 
     &      MOI(1,2), 1, ligne, voisin(N), tag1, 
     &      EUX(4,1), 1, ligne, voisin(S), tag1, 
     &      comm2d, status, icode)
!
!====
!
!Envoi au voisin S et reception du voisin N
!en utilisant le type predefini ligne
      CALL  MPI_SENDRECV ( 
     &      MOI(4,1), 1, ligne, voisin(S), tag2, 
     &      EUX(1,2), 1, ligne, voisin(N), tag2, 
     &      comm2d, status, icode)

!Envoi au voisin W et reception du voisin E
!en utilisant le type predefini colonne
!type_ligne
      CALL  MPI_SENDRECV ( 
     &      MOI(1,1), 1, colonne, voisin(W), tag1, 
     &      EUX(2,4), 1, colonne, voisin(E), tag1, 
     &      comm2d, status, icode)

!====
!
!Envoi au voisin E et reception du voisin W
!en utilisant le type predefini colonne
      CALL  MPI_SENDRECV( 
     &      MOI(2,4), 1, colonne, voisin(E), tag2, 
     &      EUX(1,1), 1, colonne, voisin(W), tag2, 
     &      comm2d, status, icode)
!
!Affiche les tableaux
      DO i = 1, 4
         WRITE (6,1010) (MOI(i,j),j=1,4), (EUX(i,j),j=1,4)
      END DO
!
!Liberation  du  type  type_ligne  et  du  communicateur  comm2d
      CALL MPI_TYPE_FREE ( ligne,   icode)
      CALL MPI_TYPE_FREE ( colonne, icode)
!
!Desactivation  de  MPI
      CALL MPI_FINALIZE (icode)
!
!===============================================================================
!===============================================================================
!
!     FIN DU PROGRAMME
!
!===============================================================================
!===============================================================================
!
      STOP
      END PROGRAM TOPOLOGIE
