# This file was *autogenerated* from the file comp.sage.
from sage.all_cmdline import *   # import sage library
_sage_const_2 = Integer(2); _sage_const_1 = Integer(1); _sage_const_8 = Integer(8); _sage_const_53 = Integer(53); _sage_const_0 = Integer(0)#-----------------------------------------------------------------------------
# define s (number of stages) and RR (precision) here.
#-----------------------------------------------------------------------------
s=_sage_const_8  #number of steps of the formula. Adapt to your needs...
RR=RealField(_sage_const_53 ) #classical "double" of C++.
#RR=RealField(112) #this seems the precision (112 bits) of "long double" in g++
#-----------------------------------------------------------------------------
# DO NOT CHANGE ANYTHING BELOW THIS LINE.
#-----------------------------------------------------------------------------
R = RR['x']; (x,) = R._first_ngens(1)#the polynomial ring.
p=x**s*(x-_sage_const_1 )**s 
l=p.derivative(x,s) #the polynomial.
theRoots=[l.roots()[i][_sage_const_0 ] for i in range(_sage_const_0 ,s)]
A=Matrix(RR,s,s)
B=Matrix(RR,s,_sage_const_1 )
# generate a_ij and b_i coefficients:
for j in range(_sage_const_0 ,s):
    lj=_sage_const_1 
    for k in range(_sage_const_0 ,s):
        if k!=j:
            lj*=(x-theRoots[k])/(theRoots[j]-theRoots[k])
    Lj=lj.integral()
    for i in range(_sage_const_0 ,s):
        A[i,j]=Lj(theRoots[i])-Lj(_sage_const_0 )
    B[j]=Lj(_sage_const_1 )-Lj(_sage_const_0 )
#
#  Verify; theorem of Cooper (see Hairer et al.).
#  All the following output must be (about) equal zero.
#
print "Cooper test:"
for i in range(_sage_const_0 ,s):
    print [B[i][_sage_const_0 ]*A[i,j]+B[j][_sage_const_0 ]*A[j,i]-B[i][_sage_const_0 ]*B[j][_sage_const_0 ] for j in range(_sage_const_0 ,s)]
print "\n"
#
# Compute the coefficients for the continuous extrapolation
# (see Hairer et al. 2nd edition, page 326).
#
# the Vandermonde matrix: 
V=Matrix(RR,s,s)
for j in range(_sage_const_0 ,s):
    for i in range(_sage_const_0 ,s):
        V[i,j]=theRoots[j]**i
# the RHS:
W=Matrix(RR,s,s)
for j in range(_sage_const_0 ,s):
    for i in range(_sage_const_0 ,s):
        W[i,j]=((_sage_const_1 +theRoots[j])**(i+_sage_const_1 ))/(i+_sage_const_1 )
# the continuous extrapolation coefficients:
Q=V * BackslashOperator() * W 
#
#---------------------------------------------------------------------------
#now generate the results in a C++ compatible syntax:
#
print "Coefficients (A):\n"
k=_sage_const_0 
for i in range(_sage_const_0 ,s):
    ch=""
    for j in range(_sage_const_0 ,s):
        ch+="a["+str(k)+"]="+str(A[i,j])+"; "
        k+=_sage_const_1 
        if k%_sage_const_2 ==_sage_const_0 :
            ch+="\n"
    print ch
print "Coefficients (B):\n"
ch=""
for i in range(_sage_const_0 ,s):
    ch+="b["+str(i)+"]="+str(B[i][_sage_const_0 ])+";"
    if i%_sage_const_2 :
        ch+="\n"
print ch
print "Coefficients (C):\n"
ch=""
for i in range(_sage_const_0 ,s):
    ch+="c["+str(i)+"]="+str(theRoots[i])+";"
    if i%_sage_const_2 :
        ch+="\n"
print ch
print "Coefficients (Q (extrapolation)):\n"
k=_sage_const_0 
for i in range(_sage_const_0 ,s):
    ch=""
    for j in range(_sage_const_0 ,s):
        ch+="q["+str(k)+"]="+str(Q[i,j])+"; "
        k+=_sage_const_1 
        if k%_sage_const_2 ==_sage_const_0 :
            ch+="\n"
    print ch
