#include "petscvec.h"

int main(int argc,char **argv)
{
	Vec x, z;
	PetscInt N = 10;
	PetscErrorCode ierr;

	ierr = PetscInitialize(&argc, &argv, PETSC_NULL, PETSC_NULL);CHKERRQ(ierr);


	ierr = VecCreate(PETSC_COMM_WORLD, &z);CHKERRQ(ierr);
	ierr = VecSetSizes(z, PETSC_DECIDE, N);CHKERRQ(ierr);
	ierr = VecSetType(z, "mpi");CHKERRQ(ierr);
	ierr = VecSetFromOptions(z);CHKERRQ(ierr);
	ierr = VecSet(z,10.);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur z\n");
	ierr = VecView(z,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);

  ierr = VecDuplicate(z,&x);CHKERRQ(ierr);
  ierr = VecSet(x,3.);CHKERRQ(ierr);
  PetscPrintf(PETSC_COMM_WORLD,"Vecteur x\n");
	ierr = VecView(x,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);
  
  
  ierr = VecAXPY(x,1.0,z);CHKERRQ(ierr);
  PetscPrintf(PETSC_COMM_WORLD,"Vecteur x\n");
	ierr = VecView(x,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);
  
  
	ierr = VecDestroy(&x);CHKERRQ(ierr);
	ierr = VecDestroy(&z);CHKERRQ(ierr);
	ierr = PetscFinalize();CHKERRQ(ierr);
	return 0;
}

