#include "petscvec.h"
#include "petscmat.h"

int main(int argc,char **argv)
{
	Vec x,y;
	Mat A;
	PetscInt N = 10;
	PetscErrorCode ierr;
	double value = 10.;
	int i;
	int row, col;
	
	ierr = PetscInitialize(&argc, &argv, PETSC_NULL, PETSC_NULL);CHKERRQ(ierr);
       
	ierr = VecCreate(PETSC_COMM_WORLD,&x);CHKERRQ(ierr);
	ierr = VecSetSizes(x,PETSC_DECIDE,N);CHKERRQ(ierr);
	ierr = VecSetFromOptions(x);CHKERRQ(ierr);
	for (i=0; i<N; i++) {
		ierr = VecSetValues(x,1,&i,&value,ADD_VALUES);CHKERRQ(ierr);
		value = (i+1)*10.;
	}
	
	ierr = VecAssemblyBegin(x);CHKERRQ(ierr);
	ierr = VecAssemblyEnd(x);CHKERRQ(ierr);
	
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur x\n");
	VecView(x, PETSC_VIEWER_STDOUT_WORLD);
	
	ierr = MatCreate(PETSC_COMM_WORLD,&A);CHKERRQ(ierr);
	ierr = MatSetSizes(A,PETSC_DECIDE,PETSC_DECIDE,N,N);CHKERRQ(ierr);
	ierr = MatSetFromOptions(A);CHKERRQ(ierr);
	ierr = MatSetUp(A);CHKERRQ(ierr);

	for (i=0;i<N;i++){
		row = i;
		col = i;
		value = 1.;
		ierr = MatSetValues(A,1,&row,1,&col,&value,INSERT_VALUES);CHKERRQ(ierr);
	}
	
	ierr = MatAssemblyBegin(A, MAT_FINAL_ASSEMBLY);CHKERRQ(ierr);
	ierr = MatAssemblyEnd(A, MAT_FINAL_ASSEMBLY);CHKERRQ(ierr);

	VecDuplicate(x,&y);
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur y\n");
	VecView(y, PETSC_VIEWER_STDOUT_WORLD);
	
	
	ierr = MatMult(A,x,y);CHKERRQ(ierr);
	
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur y\n");
	VecView(y, PETSC_VIEWER_STDOUT_WORLD);

	PetscFinalize();
	return 0;
}