#include "petscvec.h"

int main(int argc,char **argv)
{
	Vec x,y;
	PetscInt N = 10;
	PetscErrorCode ierr;
	double value = 10.;
	double norm = 0.;
	double scalaire = 0.;
	int i;
	ierr = PetscInitialize(&argc, &argv, PETSC_NULL, PETSC_NULL);CHKERRQ(ierr);
        

	ierr = VecCreate(PETSC_COMM_WORLD,&x);CHKERRQ(ierr);
	ierr = VecSetSizes(x,PETSC_DECIDE,N);CHKERRQ(ierr);
	ierr = VecSetFromOptions(x);CHKERRQ(ierr);
	for (i=0; i<N; i++) {
		ierr = VecSetValues(x,1,&i,&value,ADD_VALUES);CHKERRQ(ierr);
		value = (i+1)*10.;
	}
	
	ierr = VecAssemblyBegin(x);CHKERRQ(ierr);
	ierr = VecAssemblyEnd(x);CHKERRQ(ierr);
	
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur x\n");
	VecView(x, PETSC_VIEWER_STDOUT_WORLD);
	
	ierr = VecDuplicate(x,&y);CHKERRQ(ierr);
	ierr = VecSet(y,3.);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur y\n");
	ierr = VecView(y,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);
  
  
	ierr = VecAXPY(x,0.5,y);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur x\n");
	ierr = VecView(x,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);
  
	ierr = VecNorm(x,NORM_INFINITY,&norm);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Norme de x: %lf\n", norm);
	
	ierr = VecDot(x,y,&scalaire);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Produit scalaire x.y : %lf\n", scalaire);

	PetscFinalize();
	return 0;
}