#include "petscvec.h"

int main(int argc,char **argv)
{
	Vec x,y;
	PetscInt N = 10;
	PetscInt taille = 0;
	PetscErrorCode ierr;

	ierr = PetscInitialize(&argc, &argv, PETSC_NULL, PETSC_NULL);CHKERRQ(ierr);
	
	//Vec Seq
	ierr = VecCreateSeq(PETSC_COMM_SELF,N, &x);CHKERRQ(ierr);
	ierr = VecSetFromOptions(x);CHKERRQ(ierr);

	PetscPrintf(PETSC_COMM_SELF,"Vecteur SEQ \n");
	ierr = VecView(x,PETSC_VIEWER_STDOUT_SELF);CHKERRQ(ierr);
	ierr = VecGetSize(x,&taille);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Taille du vecteur SEQ : %d \n", taille);
	
	//Vec MPI
	ierr = VecCreateMPI(PETSC_COMM_WORLD,PETSC_DECIDE,N, &y);CHKERRQ(ierr);
	ierr = VecSetFromOptions(y);CHKERRQ(ierr);
	
	PetscPrintf(PETSC_COMM_WORLD,"Vecteur MPI \n");	
	ierr = VecView(y,PETSC_VIEWER_STDOUT_WORLD);CHKERRQ(ierr);
	ierr = VecGetSize(y,&taille);CHKERRQ(ierr);
	PetscPrintf(PETSC_COMM_WORLD,"Taille du vecteur MPI : %d \n", taille);


	ierr = VecDestroy(&x);CHKERRQ(ierr);
	ierr = VecDestroy(&y);CHKERRQ(ierr);
	
	ierr = PetscFinalize();CHKERRQ(ierr);
	return 0;
}

