//Evaluation de Pi en parallele avec Petsc

#include <petscsys.h>

static char help[] = "Pi \n";


int main(int argc,char **argv)
{
	PetscInitialize(&argc,&argv,(char *)0,help);
	
	int n = 3000000;
	double h,x,pi,summ,summloc;
	int size, rank;
	int nloc;
	int i, imin, imax;
	MPI_Comm_rank(PETSC_COMM_WORLD, &rank);
	MPI_Comm_size(PETSC_COMM_WORLD, &size);
	
	PetscPrintf(PETSC_COMM_SELF,"Je suis le processeur de rang : %d / %d \n", rank, size);

	nloc = n / size;
	h = 1.0/n;
	
	imin = rank * nloc;
	imax = (rank+1) * nloc;
	
	for (i = imin; i < imax; i++){
		x = (i - 0.5)*h;
		summloc += 4./(1. + x*x);
	}
	
	MPI_Reduce(&summloc,&summ,1,MPI_DOUBLE,MPI_SUM,0,PETSC_COMM_WORLD);
		
	pi = h*summ;
	PetscPrintf(PETSC_COMM_WORLD, "pi = %lf \n", pi);
		
	PetscFinalize();
	return 0;
}