program vp_alea

  implicit none

  ! Matrice 
  integer,parameter             :: n = 100
  real(kind=kind(1.d0))         :: a(n,n)
  
  ! Parametres, tableaux et variables de travail pour Lapack
  integer,parameter             :: lda=n, ldvl=n, ldvr=n
  integer,parameter             :: lwork = 4*n
  integer                       :: info
  real(kind=kind(1.d0))         :: vl(ldvl,n), vr(ldvr,n)
  real(kind=kind(1.d0))         :: wr(n), wi(n), work(lwork)

  integer                       :: i
      
  ! Initialisation de la matrice 
  call rng_wrapper(n,a)

  ! Appel de Lapack
  ! Solve eigenproblem.
  call dgeev('V', 'V', n, a, lda, wr, wi, vl, ldvl,  &
       vr, ldvr, work, lwork, info)
  ! Check for convergence.
  if (info .gt. 0) then
     write(*,*)'the algorithm failed to compute eigenvalues.'
     stop
  end if

  ! Sortie des 10 premieres vp
  do i = 1,10
     if (wi(i) == 0.0) then
        write(*,998) wr(i)
     else
        write(*,999) wr(i),wi(i)
     end if
  end do

998 format(11(:,1x,f6.2))
999 format(11(:,1x,'(',f6.2,',',f6.2,')'))
  
end program vp_alea
