! Point d'entree du programme. Cette fonction contient
! essentiellement la boucle d'integration 
program orego
  
  use constants
  implicit none

  ! Nombre d'equations
  integer, parameter :: neq = 3
  ! tableau contenant la solution du systeme
  real(kind=kind(1.d0))  ::  s(neq)
  ! intervalle d'integration [t,tmax] et pas d'integration
  real(kind=kind(1.d0))  ::  t, tmax, dt
  ! compteur de pas, nombre de pas d'integration
  integer   ::  n,nmax,i,isolv

  ! Parametres et tableaux de travail lsode
  integer               :: mf=21,ml=neq,mu=neq
  integer               :: itol,itask,istate,iopt,lrw,liw
  real(kind=kind(1.d0)) :: rtol,atol,tout
  real(kind=kind(1.d0)),allocatable  :: rwork(:)
  integer,allocatable                :: iwork(:) 

  ! Fonction appele par lsode
  external derive, jac

  ! Initialisation lsode
  itol = 1 ! scalaire
  rtol = 1.e-10 ! tolérance
  atol = rtol
  itask = 1
  istate = 1
  iopt = 0
  lrw = 22+9*neq+neq*neq
  allocate(rwork(lrw))
  liw = 20+neq
  allocate(iwork(liw))

  ! Initialisation
  t=0
  tmax=360
  dt=0.01
  nmax = (tmax-t)/dt

  call init(neq,s)

  ! integration par rk4
  do n = 0,nmax
     tout = t+dt
     ! afficher l'état actuel
     write(*,*) t,(s(i),i=1,neq)
     ! integrer d'un pas de temps dt
     call dlsode(derive, neq, s, t, tout, itol, rtol, atol, itask,  &
          istate, iopt, rwork, lrw, iwork, liw, jac, mf)
     t = tout
  end do

  ! affichage de l'état final
  write(*,*) t,(s(i),i=1,neq)
  
end program orego

! Conditions initiales
subroutine init (neq,s)

  implicit none

  integer  ::  neq
  real(kind=kind(1.d0))  :: s(neq)

  s(1) = 1.
  s(2) = 2.
  s(3) = 3.

end subroutine init

! Calcul du second membre du systeme
! Routine appelée par lsode
subroutine derive(neq,t,s,ds)
  
  use constants
  implicit none

  integer  ::  neq
  real(kind=kind(1.d0))  :: s(neq),ds(neq),t
  
 
  ds(1) = p*(s(2)-s(1)*s(2)+s(1)-r*s(1)*s(1))
  ds(2) = 1/p*(-s(2)-s(1)*s(2)+s(3))
  ds(3) = q*(s(1)-s(3))

end subroutine derive

! Calcul du jacobien
! Appelé par lsode
!subroutine jac(n,t,s,ds,lds,rpar,ipar)
subroutine jac(n,t,s,ml,mu,ds,nrowpd)

  use constants
  implicit none

  integer    :: n,ml,mu,nrowpd
  real(kind=kind(1.d0))  :: t,s(n),ds(nrowpd,n)

  ds(1,1) = p*(-s(2)+1.-2.*r*s(1)) 
  ds(1,2) = p*(1.-s(1))
  ds(1,3) = 0.

  ds(2,1) = -s(2)/p
  ds(2,2) = -1/p*(1.+s(1))
  ds(2,3) = 1/p
  
  ds(3,1) = q
  ds(3,2) = 0.
  ds(3,3) = -q

end subroutine jac
