! Point d'entree du programme. Cette fonction contient
! essentiellement la boucle d'integration et l'affichage de la solution a
! chaque pas de temps
program bruss
  
  implicit none

  ! Nombre d'equations
  integer, parameter :: neq = 2
  ! Parametres A et B
  character(len=10)      :: cA,cB
  real(kind=kind(1.d0))  :: A, B
  ! tableau contenant la solution du systeme
  real(kind=kind(1.d0))  ::  s(neq)
  ! intervalle d'integration [t,tmax] et pas d'integration
  real(kind=kind(1.d0))  ::  t, tmax, dt
  ! compteur de pas, nombre de pas d'integration
  integer   ::  n,nmax,i

  ! On recupere les arguments du fichier dat a et b
  open(unit=3,file='dat',form='formatted')
  read(3,*) A
  read(3,*) B
  close(3)

  ! Initialisation
  t=0
  tmax=30
  dt=0.01
  nmax = (tmax-t)/dt

  call init(neq,s)

  ! integration
  do n = 0,nmax
     t = n*dt
     ! afficher l'état actuel
     write(*,*) t,(s(i),i=1,neq)
     ! integrer d'un pas de temps dt
     call rk4(neq,s,dt,A,B)
  end do

  ! affichage de l'état final
  t = n*dt
  write(*,*) t,(s(i),i=1,neq)

end program bruss

! Conditions initiales
subroutine init (neq,s)

  implicit none

  integer  ::  neq
  real(kind=kind(1.d0))  :: s(neq)

  s(1) = 1.5
  s(2) = 3.

end subroutine init

! Calcul du second membre du systeme
subroutine derive(neq, s, ds,A,B) 
  
  implicit none

  integer  ::  neq
  real(kind=kind(1.d0))  :: s(neq),ds(neq),A,B
  
  ds(1) = A - (B+1.)*s(1) + s(1)*s(1)*s(2)
  ds(2) = B*s(1) - s(1)*s(1)*s(2)

end subroutine derive

! Cette fonction integre les equations d'evolution sur un pas de
!   temps dt, selon un schéma de Runge-Kutta d'ordre 4, en partant de
!   l'etat contenu dans le tableau u. Le nouvel etat du systeme
!   est finalement stocke dans le meme tableau. 
subroutine rk4(neq,u,dt,A,B)

  implicit none
  
  integer  ::  neq
  real(kind=kind(1.d0))  :: u(neq),dt,A,B

  real(kind=kind(1.d0))  :: utmp(neq),k1(neq),k2(neq),k3(neq),k4(neq)
  integer   :: i

  ! k1 = f(u)
  call derive(neq,u,k1,A,B)

  ! k2 = f(u+0.5*dt*k1)
  do i = 1,neq
     utmp(i) = u(i) + 0.5*dt*k1(i)
  end do
  call derive(neq,utmp,k2,A,B)

  ! k3 = f(u+0.5*dt*k2)
  do i = 1,neq
     utmp(i) = u(i) +0.5*dt*k2(i)
  end do
  call derive(neq,utmp,k3,A,B)

  ! k4 = f(u+dt*k3)
  do i = 1,neq
     utmp(i) = u(i) + dt*k3(i)
  end do
  call derive(neq,utmp,k4,A,B)

  ! u = utmp + dt/6 * (k1 + 2*k2 + 2*k3 + k4)
  do i = 1,neq
     u(i) = u(i) + dt/6.*(k1(i) + 2.*k2(i) + 2.*k3(i) + k4(i));
  end do

end subroutine rk4


