!Produit matrice vecteur 
program  prodMatVecOpenMP
  use OMP_LIB
  implicit none

  ! Precision des reels
  integer, parameter ::  dp = kind(1.0d0)

  integer, parameter ::  n = 625
  real(dp), dimension(n,n) :: a
  real(dp), dimension(n) :: x, y, yy
  real(dp) :: yNorm = 0.d0
  integer :: i, j
  integer :: numThreads

  print '("Calcul du produit matrice vecteur : y = A.x")'

  !$omp parallel private(yy)

  !$omp master
  numThreads = omp_get_num_threads()
  !$omp end master

  !Initialisation de la matrice
  !$omp do private(i) schedule(runtime)
  do j = 1, n
    do i = 1, n
      a(i,j) = sqrt(dble(j) / (dble(n*(n+1)) / 2.d0))
    end do
  end do
  !$omp end do

  !Initialisation des vecteurs x et y
  !$omp do schedule(runtime)
  do i = 1, n
    x(i) = sqrt(dble(i) / (dble(n*(n+1)) / 2.d0))
    y(i) = 0.d0
  end do
  !$omp end do

  !Produit matrice vecteur
  yy(1:n) = 0.d0
  !$omp do private(i) schedule(runtime)
   do j = 1, n
     do i = 1, n
        yy(i) = yy(i) + a(i,j) * x(j)
     end do
   end do
  !$omp end do
  !$omp critical
   do i = 1, n
     y(i) = y(i) + yy(i)
   enddo
  !$omp end critical

  !$omp barrier

  !Norme de y
  !$omp do reduction(+:yNorm) schedule(runtime)
  do i = 1, n
     yNorm = yNorm + y(i)*y(i)
  end do
  !$omp end do
  !$omp end parallel


  !Test du produit matrice vecteur
  print '("Execution sur",i2," threads")', numThreads
  print '("--> Norme calculee du vecteur y = A.x : ",f10.5)', sqrt(yNorm)
  print '("--> Norme prevue   du vecteur y = A.x : ",f10.5)', sqrt(dble(n)) 

end program prodMatVecOpenMP
