program section
use omp_lib
implicit none
integer, parameter :: n = 20
integer rang, i
real(kind=kind(1.d0)), dimension(n) :: x, y
real(kind=kind(1.d0)) :: xy

xy = 0.d0

!$omp parallel private (rang, i)
rang = omp_get_thread_num()

!$omp sections

  !$omp section
  print *,"Initialisation du vecteur x &
    thread :", rang
  do i = 1, n
    x(i) = sqrt(dfloat(i))
  end do

  !$omp section
  print *,"Initialisation du vecteur y &
    thread :", rang
  do i = 1, n
    y(i) = sqrt(dfloat(i))
  end do

!$omp end sections

!$omp do reduction(+:xy)
do i = 1, n
  xy = xy + x(i)*y(i)
end do
!omp end do

!$omp end parallel

print *, "Produit scalaire de x par y :", xy
print *, "Resultats attendus :", (n*(n+1))/2.d0

end program section
