! Programme Pi openMP 
program pi_openmp
  use omp_lib
  implicit none

  integer, parameter :: dp = kind(1.0d0)
  integer, parameter :: n  = 3000000 
  integer :: i
  real(dp) :: h, x, pi, summ
  integer :: numThreads
  integer :: irang 

  !$omp parallel
  numThreads = omp_get_num_threads()
  !$omp end parallel
  print '("Calcul de pi en parallele sur ",i2," threads")', numThreads

  summ = 0.d0
  h = 1.d0 / (real(n, dp)) 

  !$omp parallel do reduction(+:summ)  private(x)
  do i = 1, n
    x = (real(i, dp) - 0.5d0) * h 
    summ = summ + (4.d0 / (1.d0+ (x*x)))
  end do
  !$omp end parallel do

  pi = h * summ

  print*, 'Pi = ', pi

end program pi_openmp
