! Programme Pi openMP 
program pi_openmp
  use omp_lib
  implicit none

  integer, parameter :: dp = kind(1.0d0)
  integer, parameter :: n  = 3000000 
  integer :: i, imin, imax, nloc
  real(dp) :: h, x, pi, summ
  real(dp), dimension(:), allocatable :: summloc
  integer :: numThreads
  integer :: irang 

  !$omp parallel
  numThreads = omp_get_num_threads()
  !$omp end parallel
  print '("Calcul de pi en parallele sur ",i2," threads")', numThreads

  nloc = n / numThreads
  print '("Chaque thread calcule ",i10," intervalles")', nloc

  allocate(summloc(numThreads))

  summloc = 0.d0
  h = 1.d0 / (real(n, dp)) 
  
  ! Region parallele 
  !$omp parallel private(i, imin, imax, x, irang)

  ! Rang de la thread : 0, 1 ...numThreads-1  */ 
  irang = omp_get_thread_num()

  imin = irang * nloc + 1
  imax = (irang + 1) * nloc

  ! Chaque thread de rang irang calcule sa somme dans summloc(irang+1)
  do i = imin, imax
    x = (real(i, dp) - 0.5d0) * h 
    summloc(irang+1) = summloc(irang+1) + (4.d0 / (1.d0+ (x*x)))
  end do
  !$omp end parallel

  do i = 1, numThreads
     summ = summ + summloc(i)
  end do

  pi = h * summ

  print*, 'Pi = ', pi

end program pi_openmp
