! Programme Pi sequentiel 
program pi_seq

  implicit none

! Precision des entiers longs et des reels
  integer, parameter ::  dp = kind(1.0d0)
  integer, parameter :: n  = 3000000
  integer :: i 
  real(dp) :: h, x, pi, summ 

  summ = 0.d0
  h = 1.d0 / (real(n, dp)) 

  !$omp parallel do private(x) reduction(+:summ)
  do i = 1, n
     x = (real(i, dp) - 0.5d0) * h 
     summ = summ + (4.d0 / (1.d0 + (x*x))) 
  end do
  !$omp end parallel do


  pi = h * summ

  print*, 'Pi = ', pi

end program pi_seq
