! Produit matrice vecteur 
program  workshare
  use omp_lib 
  implicit none

  ! Precision des reels
  integer, parameter ::  dp = kind(1.0d0)

  integer, parameter ::  n = 625
  !!real(dp), dimension(n,n) :: a
  real(dp), dimension(:,:), allocatable :: a
  real(dp), dimension(n) :: x, y
  real(dp) :: yNorm
  integer :: nbThreads
  integer :: i, j

  allocate(a(n,n))

  print '("Calcul du produit matrice vecteur : y = A.x")'
  ! Initialisation de la matrice
  do j = 1, n
    do i = 1, n
      a(i,j) = sqrt(dble(j) / (dble(n*(n+1)) / 2.d0))
    end do
  end do

  ! Initialisation des vecteurs x et y
  do i = 1, n
    x(i) = sqrt(dble(i)/ (dble(n*(n+1)) / 2.d0))
    y(i) = 0.d0
  end do

  ! Produit matrice vecteur
  !$omp parallel 
  nbThreads = omp_get_num_threads()
  !$omp workshare
  y = matmul(a,x)
  !$omp end workshare
  !$omp end parallel

  ! Test du produit matrice vecteur
  yNorm = dot_product(y,y)
  print '("Execution parallele sur ", i2, " threads")', nbThreads
  print '("--> Norme calculee du vecteur y = A.x : ",f10.5)', sqrt(yNorm)
  print '("--> Norme prevue   du vecteur y = A.x : ",f10.5)', sqrt(dble(n))

end program workshare
