program orphan
use omp_lib
implicit none
integer, parameter :: n = 20
real(kind=kind(1.d0)), dimension(n) :: x, y
real(kind=kind(1.d0)) :: xy, prodScal
integer :: i

do i = 1, n
  x(i) = sqrt(dfloat(i))
  y(i) = sqrt(dfloat(i))
end do

!$omp parallel
xy = prodScal(n, x, y) 
!$omp end parallel

print *, 'Produit scalaire de x par y :', xy
print *, 'Resultat attendu :', (n*(n+1))/2.d0

end program orphan
