program tranfMatrice

  implicit none

  integer, parameter   :: n = 10, m = 5

  real, dimension(n,m) :: mat
  integer              :: ios,choix,i
  real, external       :: carre, identite, logarithme
  real, intrinsic      :: sqrt

  ! Ouverture du fichier contenant la matrice.
  open(unit=1,file="exo6.matrice",        &
       form="unformatted", action="read", &
       status="old",position="rewind",    &
       iostat=ios)

  if (ios /= 0) &
    stop 'Erreur à l''ouverture du fichier "exo6.matrice"'
  ! Lecture de la matrice
  read(1) mat
  close(1)
  
  ! Lecture du choix de la transformation
  write(*,*) "Choix de la tranformation &
       &(0: identité, 1: carré, 2: racine, 3: logarithme) ?"
  read(*,*) choix

  select case(choix)
    case (0)
      call transform(mat, n, m, identite)
    case (1)
      call transform(mat, n, m, carre)
    case (2)
      call transform(mat, n, m, sqrt)
    case (3)
      call transform(mat, n, m, logarithme)
  end select

  do i=1,n
    print*,mat(i,:)
  end do  

end program tranfMatrice
