module MyComplexMod

  implicit none
  
  type MyComplex
    real(kind=kind(1.d0))   :: xr,xi
  end type

contains

  function addition(yc1,yc2)

    type(MyComplex), intent(in) :: yc1, yc2
    type(MyComplex)             :: addition
    
    addition%xr = yc1%xr + yc2%xr
    addition%xi = yc1%xi + yc2%xi
    
  end function addition

  function soustraction(yc1,yc2)

    type(MyComplex), intent(in) :: yc1, yc2
    type(MyComplex)             :: soustraction

    soustraction%xr = yc1%xr - yc2%xr
    soustraction%xi = yc1%xi - yc2%xi

  end function soustraction
  
  function multiplication(yc1,yc2)
    
    type(MyComplex), intent(in) :: yc1, yc2
    type(MyComplex)             :: multiplication
    
    multiplication%xr = (yc1%xr*yc2%xr - yc1%xi*yc2%xi)
    multiplication%xi = (yc1%xr*yc2%xi + yc1%xi*yc2%xr)
    
  end function multiplication

  function division(yc1,yc2)

    type(MyComplex),intent(in) :: yc1, yc2
    type(MyComplex)            :: division
    
    real(kind=kind(1.d0))      :: x
    type(MyComplex)            :: ytmp

    x = 1./(yc2%xr*yc2%xr + yc2%xi*yc2%xi)
    ytmp%xr = yc2%xr
    ytmp%xi = -yc2%xi
    division = multiplication(yc1,ytmp)
    division%xr = division%xr*x
    division%xi = division%xi*x
    
  end function division

  subroutine printCplx(yc)

    type(MyComplex),intent(in) :: yc

    print *,"Nombre Complex : (",yc%xr,",",yc%xi,")"
  
  end subroutine printCplx

end module MyComplexMod
