program test_cg
  use laplacian_mod
  use linalg_mod
  implicit none

  type(CSR) :: A
  real(kind=8), pointer, dimension(:) :: b, x
  INTEGER :: nx, ny
  REAL(kind=8) :: dx, dy
  character(len=100)  :: name

  !!!!
  !! init data
  !!!!
  nx = 101
  ny = 101
  dx = 1.d0/(nx+1)
  dy = 1.d0/(ny+1)

  allocate(b(nx*ny), x(nx*ny))  
  b = 1.d0
  x = 1.d0

  !!!!
  !! put Dirichlet condition in the second member
  !!!!
  call setDirichlet(b, nx, ny, dx, dy)

  !!!!
  !! Laplacian matrix construction 
  !! without Dirichlet points
  !!!!
  call LaplacianMatrix(A, nx, ny, dx, dy)

  !!!!
  !! solve Ax = b with my conjugate gradient
  !!!!
  call cg(A, b, x, 1.d-6, 200)

  !!!!
  !! save x in VTK format
  !!!!
  name="test_cg.vts"
  ! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  !!!!
  !! Destroy A, b and x
  !!!!
  call destroyCSR(A)
  deallocate(b, x)

end program test_cg
