program test_cg
  use interface_mod
  use laplacian_mod
  use linalg_mod
  use mpi
  implicit none

  type(CSR) :: A
  real(kind=8), pointer, dimension(:) :: b, x
  INTEGER :: nx, ny, nxloc, nyloc
  INTEGER :: npx, npy, npx_coord, npy_coord
  INTEGER :: ierr, rank, size
  REAL(kind=8) :: dx, dy
  integer :: decx, decy
  CHARACTER(len=80) :: nom_fich
  type(interface), dimension(4) :: interf
  character(len=10) :: param
  

  call mpi_init(ierr)

  !!!!
  !! init data
  !!!!
  nx = 100
  ny = 100
  dx = 1.d0/(nx+1)
  dy = 1.d0/(ny+1)

  !!!!
  !! get number of subdomains in x and y directions
  !!!!
  call getarg(1,param)
  read(param,*)npx

  call getarg(2,param)
  read(param,*)npy

  !!!!
  !! get local coords
  !!!!
  call mpi_comm_rank(mpi_comm_world, rank, ierr)
  npx_coord = mod(rank, npx)
  npy_coord = rank/npx

  !!!!
  !! set local size of the grid points
  !!!!
  nxloc = nx/npx 
  nyloc = ny/npy 

  if (npx_coord == npx-1) then
     nxloc = nxloc + mod(nx, npx)
  end if

  if (npy_coord == npy-1) then
     nyloc = nyloc + mod(ny, npy)
  end if

  !!!!
  !! set interfaces
  !!!!
  call init_interface(nxloc, nyloc, dx, dy, npx_coord, npy_coord, npx, npy, interf)
  !call print_interface(interf)
  
  allocate(b(nxloc*nyloc), x(nxloc*nyloc))  
  b = 10.d0
  x = 1.d0

  !!!!
  !! put Dirichlet condition in the second member
  !!!!
  call setDirichlet(b, nxloc, nyloc, dx, dy, interf)

  !!!!
  !! Laplacian matrix construction 
  !! without Dirichlet points
  !!!!
  call LaplacianMatrix(A, nxloc, nyloc, dx, dy)

  !!!!
  !! solve Ax = b with my conjugate gradient
  !!!!
  call cgPara(A, b, x, interf, 1.d-6, 100000)

  !!!!
  !! save x in VTK format
  !!!!
  nom_fich = "testcg"
  decx = npx_coord*nxloc
  decy = npy_coord*nyloc
  call save_vtk(nxloc, nyloc, dx, dy, decx, decy, x, "testcg")

  !!!!
  !! Destroy A, b and x
  !!!!
  call destroyCSR(A)
  deallocate(b, x)
  call MPI_finalize(ierr)
end program test_cg

