#include <iostream>
#include <sstream>

#include "vtkDoubleArray.h"
#include "vtkPoints.h"
#include "vtkPointData.h"
#include "vtkStructuredGrid.h"
#include "vtkXMLStructuredGridWriter.h"

#include "mpi.h"

using namespace std;

extern "C"{
  void save_vtk_(int *nx, int *ny, double *dx, double *dy, int *decx, int *decy, double *tab, char *filename);
}

void save_vtk_(int *nx, int *ny, double *dx, double *dy, int *decx, int *decy, double *tab, char *filename)
{
  int i, j;
  int rank, size;

  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
    
  vtkStructuredGrid* dataSet = vtkStructuredGrid::New();
  dataSet->SetExtent(*decx, *decx + *nx - 1, *decy, *decy + *ny - 1, 0, 0);
  vtkPoints* Points = vtkPoints::New();

  vtkDoubleArray* sol = vtkDoubleArray::New();
  sol->SetName("solution");
	
  for (int j=0; j<*ny; j++)
    for (int i=0; i<*nx; i++)
      {
        Points->InsertNextPoint((*decx + i)*(*dx), (*decy + j)*(*dy), 0.);
        sol->InsertNextValue(tab[i+j*(*nx)]);
      }

  dataSet->SetPoints(Points);
  dataSet->GetPointData()->SetScalars(sol);
	
  vtkXMLStructuredGridWriter* dataWriter = vtkXMLStructuredGridWriter::New();
  stringstream o;
  o << filename << '_' << rank << ".vts";
  dataWriter->SetFileName(o.str().data());

  dataWriter->SetInput(dataSet);
  dataWriter->Write();

  int x[size], y[size];
  int sx[size], sy[size];
  MPI_Gather(decx, 1, MPI_INT, x, 1, MPI_INT, 0, MPI_COMM_WORLD);
  MPI_Gather(nx, 1, MPI_INT, sx, 1, MPI_INT, 0, MPI_COMM_WORLD);

  MPI_Gather(decy, 1, MPI_INT, y, 1, MPI_INT, 0, MPI_COMM_WORLD);
  MPI_Gather(ny, 1, MPI_INT, sy, 1, MPI_INT, 0, MPI_COMM_WORLD);

  if (rank == 0){
    stringstream oall;
    oall << filename << ".pvts";
    ofstream pvts;
    pvts.open(oall.str().data(), ios::out | ios::trunc);
    pvts << "<?xml version=\"1.0\"?>" << endl;
    pvts << "<VTKFile type=\"PStructuredGrid\" version=\"0.1\" byte_order=\"LittleEndian\" compressor=\"vtkZLibDataCompressor\">" << endl;
    pvts << "<PStructuredGrid WholeExtent=\"0 " << 1 << " 0 " << 1 << " 0 0\" GhostLevel=\"0\">";
    pvts << "<PPoints>" << endl;
    pvts << "<PDataArray type=\"Float32\" Name=\"Points\" NumberOfComponents=\"3\"/>" << endl;
    pvts << "</PPoints>" << endl;
    pvts << "<PPointData Scalars=\"solution\">" << endl;
    pvts << "<PDataArray type=\"Float64\" Name=\"solution\"/>" << endl;
    pvts << "</PPointData>" << endl;
    pvts << "<PCells>" << endl;
    pvts << "</PCells>" << endl;
    // Attention!! ajout d'un point apres source pour aller dans le repertoire ..
    // changer les arguments d'entree en dir et filename
    for(int i=0; i<size; i++)
      pvts << "<Piece Extent=\"" << x[i] << " " << x[i]+sx[i]-1 << " " << y[i] << " " << y[i]+sy[i]-1 << " " << " 0 0\" Source=\"./" << filename << "_" << i << ".vts\"/>" << endl;
        pvts << "</PStructuredGrid>" << endl;
    pvts << "</VTKFile>" << endl;
    pvts.close();
  }


}
