module util_mod
  use mpi
  use interface_mod
  use CSR_mod
contains
  !> parallel matrix product y = A*x
  !! @param A CSR matrix
  !! @param x vector
  !! @param y vector
  !! @param interf interfaces array
  subroutine matmultpara(A, x, y, interf)
    TYPE(CSR) :: A
    REAL(kind=8), DIMENSION(:) :: x, y
    REAL(kind=8) :: dx2
    type(interface), dimension(:) :: interf
    integer :: i

    call update_interface(x, interf)
    call matmult(A, x, y)

    do i=1,4
       if (interf(i)%isInterface) then
          dx2 = 1./interf(i)%dx/interf(i)%dx
          y(interf(i)%nodes) = y(interf(i)%nodes) - dx2*interf(i)%val
       end if
    end do

  end subroutine matmultpara
    
  !> parallel dot product 
  !! @param x vector
  !! @param y vector
  function dot_product_para(x, y)
    real(kind=8), dimension(:) :: x, y
    real(kind=8) :: tmp, dot_product_para
    integer :: ierr

    tmp = DOT_PRODUCT(x, y)
    call mpi_allreduce(tmp, dot_product_para, 1, mpi_double_precision, mpi_sum, mpi_comm_world, ierr)
    
  end function dot_product_para
end module util_mod
